/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.http;

import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.query.QueryExecException;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.sparql.ARQException;
import com.hp.hpl.jena.sparql.engine.http.HttpQuery;
import com.hp.hpl.jena.sparql.engine.http.Params;
import com.hp.hpl.jena.sparql.engine.http.Service;
import com.hp.hpl.jena.sparql.graph.GraphFactory;
import com.hp.hpl.jena.sparql.resultset.CSVInput;
import com.hp.hpl.jena.sparql.resultset.JSONInput;
import com.hp.hpl.jena.sparql.resultset.TSVInput;
import com.hp.hpl.jena.sparql.resultset.XMLInput;
import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.util.FileManager;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RiotReader;
import org.apache.jena.riot.WebContent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryEngineHTTP
implements QueryExecution {
    private static Logger log = LoggerFactory.getLogger(QueryEngineHTTP.class);
    public static final String QUERY_MIME_TYPE = "application/sparql-query";
    private final Query query;
    private final String queryString;
    private final String service;
    private final Context context;
    Params params = null;
    List<String> defaultGraphURIs = new ArrayList<String>();
    List<String> namedGraphURIs = new ArrayList<String>();
    private String user = null;
    private char[] password = null;
    private boolean finished = false;
    private long connectTimeout = -1L;
    private TimeUnit connectTimeoutUnit = TimeUnit.MILLISECONDS;
    private long readTimeout = -1L;
    private TimeUnit readTimeoutUnit = TimeUnit.MILLISECONDS;
    private boolean allowGZip = true;
    private boolean allowDeflate = true;
    private String selectContentType = "application/sparql-results+xml";
    private String askContentType = "application/sparql-results+xml";
    private String modelContentType = "application/rdf+xml";
    public static String[] supportedSelectContentTypes = new String[]{"application/sparql-results+xml", "application/sparql-results+json", "text/tab-separated-values", "text/csv"};
    public static String[] supportedAskContentTypes = new String[]{"application/sparql-results+xml", "application/json", "text/tab-separated-values", "text/csv"};
    private InputStream retainedConnection = null;

    public QueryEngineHTTP(String serviceURI, Query query2) {
        this(serviceURI, query2, query2.toString());
    }

    public QueryEngineHTTP(String serviceURI, String queryString) {
        this(serviceURI, null, queryString);
    }

    private QueryEngineHTTP(String serviceURI, Query query2, String queryString) {
        this.query = query2;
        this.queryString = queryString;
        this.service = serviceURI;
        this.context = new Context(ARQ.getContext());
        QueryEngineHTTP.applyServiceConfig(serviceURI, this);
    }

    private static void applyServiceConfig(String serviceURI, QueryEngineHTTP engine) {
        if (engine.context == null) {
            return;
        }
        Map serviceContextMap = (Map)engine.context.get(Service.serviceContext);
        if (serviceContextMap != null && serviceContextMap.containsKey(serviceURI)) {
            Context serviceContext = (Context)serviceContextMap.get(serviceURI);
            if (log.isDebugEnabled()) {
                log.debug("Endpoint URI {} has SERVICE Context: {} ", (Object)serviceURI, (Object)serviceContext);
            }
            engine.setAllowGZip(serviceContext.isTrueOrUndef(Service.queryGzip));
            engine.setAllowDeflate(serviceContext.isTrueOrUndef(Service.queryDeflate));
            QueryEngineHTTP.applyServiceTimeouts(engine, serviceContext);
            String user = serviceContext.getAsString(Service.queryAuthUser);
            String pwd = serviceContext.getAsString(Service.queryAuthPwd);
            if (user != null || pwd != null) {
                user = user == null ? "" : user;
                String string = pwd = pwd == null ? "" : pwd;
                if (log.isDebugEnabled()) {
                    log.debug("Setting basic HTTP authentication for endpoint URI {} with username: {} ", (Object)serviceURI, (Object)user);
                }
                engine.setBasicAuthentication(user, pwd.toCharArray());
            }
        }
    }

    private static void applyServiceTimeouts(QueryEngineHTTP engine, Context context) {
        if (context.isDefined(Service.queryTimeout)) {
            Object obj = context.get(Service.queryTimeout);
            if (obj instanceof Number) {
                int x = ((Number)obj).intValue();
                engine.setTimeout(-1L, x);
            } else if (obj instanceof String) {
                try {
                    String str2 = obj.toString();
                    if (str2.contains(",")) {
                        String[] a = str2.split(",");
                        int connect = Integer.parseInt(a[0]);
                        int read = Integer.parseInt(a[1]);
                        engine.setTimeout((long)read, connect);
                    }
                    int x = Integer.parseInt(str2);
                    engine.setTimeout(-1L, x);
                }
                catch (NumberFormatException ex) {
                    throw new QueryExecException("Can't interpret string for timeout: " + obj);
                }
            } else {
                throw new QueryExecException("Can't interpret timeout: " + obj);
            }
        }
    }

    @Override
    public void setFileManager(FileManager fm) {
        throw new UnsupportedOperationException("FileManagers do not apply to remote query execution");
    }

    @Override
    public void setInitialBinding(QuerySolution binding) {
        throw new UnsupportedOperationException("Initial bindings not supported for remote queries, consider using a ParameterizedSparqlString to prepare a query for remote execution");
    }

    public void setInitialBindings(ResultSet table) {
        throw new UnsupportedOperationException("Initial bindings not supported for remote queries, consider using a ParameterizedSparqlString to prepare a query for remote execution");
    }

    public void setDefaultGraphURIs(List<String> defaultGraphURIs) {
        this.defaultGraphURIs = defaultGraphURIs;
    }

    public void setNamedGraphURIs(List<String> namedGraphURIs) {
        this.namedGraphURIs = namedGraphURIs;
    }

    public void setAllowGZip(boolean allowed) {
        this.allowGZip = allowed;
    }

    public void setAllowDeflate(boolean allowed) {
        this.allowDeflate = allowed;
    }

    public void addParam(String field, String value) {
        if (this.params == null) {
            this.params = new Params();
        }
        this.params.addParam(field, value);
    }

    public void addDefaultGraph(String defaultGraph) {
        if (this.defaultGraphURIs == null) {
            this.defaultGraphURIs = new ArrayList<String>();
        }
        this.defaultGraphURIs.add(defaultGraph);
    }

    public void addNamedGraph(String name) {
        if (this.namedGraphURIs == null) {
            this.namedGraphURIs = new ArrayList<String>();
        }
        this.namedGraphURIs.add(name);
    }

    public boolean isUsingBasicAuthentication() {
        return this.user != null || this.password != null;
    }

    public void setBasicAuthentication(String user, char[] password) {
        this.user = user;
        this.password = password;
    }

    @Override
    public ResultSet execSelect() {
        InputStream in;
        HttpQuery httpQuery = this.makeHttpQuery();
        httpQuery.setAccept(this.selectContentType);
        this.retainedConnection = in = httpQuery.exec();
        String actualContentType = httpQuery.getContentType();
        if (actualContentType == null || actualContentType.equals("")) {
            actualContentType = this.selectContentType;
        }
        if (actualContentType.equals("application/sparql-results+xml")) {
            return ResultSetFactory.fromXML(in);
        }
        if (actualContentType.equals("application/sparql-results+json")) {
            return ResultSetFactory.fromJSON(in);
        }
        if (actualContentType.equals("text/tab-separated-values")) {
            return ResultSetFactory.fromTSV(in);
        }
        if (actualContentType.equals("text/csv")) {
            return CSVInput.fromCSV(in);
        }
        throw new QueryException("Endpoint returned Content-Type: " + actualContentType + " which is not currently supported for SELECT queries");
    }

    @Override
    public Model execConstruct() {
        return this.execConstruct(GraphFactory.makeJenaDefaultModel());
    }

    @Override
    public Model execConstruct(Model model) {
        return this.execModel(model);
    }

    @Override
    public Iterator<Triple> execConstructTriples() {
        return this.execTriples();
    }

    @Override
    public Model execDescribe() {
        return this.execDescribe(GraphFactory.makeJenaDefaultModel());
    }

    @Override
    public Model execDescribe(Model model) {
        return this.execModel(model);
    }

    @Override
    public Iterator<Triple> execDescribeTriples() {
        return this.execTriples();
    }

    private Model execModel(Model model) {
        Lang lang;
        HttpQuery httpQuery = this.makeHttpQuery();
        httpQuery.setAccept(this.modelContentType);
        InputStream in = httpQuery.exec();
        String actualContentType = httpQuery.getContentType();
        if (actualContentType == null || actualContentType.equals("")) {
            actualContentType = this.modelContentType;
        }
        if (!RDFLanguages.isTriples(lang = WebContent.contentTypeToLang(actualContentType))) {
            throw new QueryException("Endpoint returned Content Type: " + actualContentType + " which is not a valid RDF Graph syntax");
        }
        RDFDataMgr.read(model, in, lang);
        this.close();
        return model;
    }

    private Iterator<Triple> execTriples() {
        Lang lang;
        HttpQuery httpQuery = this.makeHttpQuery();
        httpQuery.setAccept(this.modelContentType);
        InputStream in = httpQuery.exec();
        String actualContentType = httpQuery.getContentType();
        if (actualContentType == null || actualContentType.equals("")) {
            actualContentType = this.modelContentType;
        }
        if (!RDFLanguages.isTriples(lang = WebContent.contentTypeToLang(actualContentType))) {
            throw new QueryException("Endpoint returned Content Type: " + actualContentType + " which is not a valid RDF Graph syntax");
        }
        return RiotReader.createIteratorTriples(in, lang, null);
    }

    @Override
    public boolean execAsk() {
        HttpQuery httpQuery = this.makeHttpQuery();
        httpQuery.setAccept(this.askContentType);
        InputStream in = httpQuery.exec();
        try {
            Lang lang;
            String actualContentType = httpQuery.getContentType();
            if (actualContentType == null || actualContentType.equals("")) {
                actualContentType = this.askContentType;
            }
            if (!RDFLanguages.isTriples(lang = WebContent.contentTypeToLang(actualContentType)) && actualContentType.equals("application/sparql-results+xml")) {
                boolean bl = XMLInput.booleanFromXML(in);
                return bl;
            }
            if (actualContentType.equals("application/sparql-results+json")) {
                boolean bl = JSONInput.booleanFromJSON(in);
                return bl;
            }
            if (actualContentType.equals("text/tab-separated-values")) {
                boolean bl = TSVInput.booleanFromTSV(in);
                return bl;
            }
            if (actualContentType.equals("text/csv")) {
                boolean bl = CSVInput.booleanFromCSV(in);
                return bl;
            }
            throw new QueryException("Endpoint returned Content-Type: " + actualContentType + " which is not currently supported for ASK queries");
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e2) {
                log.warn("Failed to close connection", (Throwable)e2);
            }
        }
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    @Override
    public Dataset getDataset() {
        return null;
    }

    @Override
    public Query getQuery() {
        return this.query;
    }

    @Override
    public void setTimeout(long readTimeout) {
        this.readTimeout = readTimeout;
        this.readTimeoutUnit = TimeUnit.MILLISECONDS;
    }

    @Override
    public void setTimeout(long readTimeout, long connectTimeout) {
        this.readTimeout = readTimeout;
        this.readTimeoutUnit = TimeUnit.MILLISECONDS;
        this.connectTimeout = connectTimeout;
        this.connectTimeoutUnit = TimeUnit.MILLISECONDS;
    }

    @Override
    public void setTimeout(long readTimeout, TimeUnit timeoutUnits) {
        this.readTimeout = readTimeout;
        this.readTimeoutUnit = timeoutUnits;
    }

    @Override
    public void setTimeout(long timeout1, TimeUnit timeUnit1, long timeout2, TimeUnit timeUnit2) {
        this.readTimeout = timeout1;
        this.readTimeoutUnit = timeUnit1;
        this.connectTimeout = timeout2;
        this.connectTimeoutUnit = timeUnit2;
    }

    @Override
    public long getTimeout1() {
        return QueryEngineHTTP.asMillis(this.readTimeout, this.readTimeoutUnit);
    }

    @Override
    public long getTimeout2() {
        return QueryEngineHTTP.asMillis(this.connectTimeout, this.connectTimeoutUnit);
    }

    public boolean getAllowGZip() {
        return this.allowGZip;
    }

    public boolean getAllowDeflate() {
        return this.allowDeflate;
    }

    private static long asMillis(long duration, TimeUnit timeUnit) {
        return duration < 0L ? duration : timeUnit.toMillis(duration);
    }

    private HttpQuery makeHttpQuery() {
        if (this.finished) {
            throw new ARQException("HTTP execution already closed");
        }
        HttpQuery httpQuery = new HttpQuery(this.service);
        httpQuery.merge(QueryEngineHTTP.getServiceParams(this.service, this.context));
        httpQuery.addParam("query", this.queryString);
        for (String dft : this.defaultGraphURIs) {
            httpQuery.addParam("default-graph-uri", dft);
        }
        for (String name : this.namedGraphURIs) {
            httpQuery.addParam("named-graph-uri", name);
        }
        if (this.params != null) {
            httpQuery.merge(this.params);
        }
        if (this.allowGZip) {
            httpQuery.setAllowGZip(true);
        }
        if (this.allowDeflate) {
            httpQuery.setAllowDeflate(true);
        }
        httpQuery.setBasicAuthentication(this.user, this.password);
        if (this.connectTimeout > 0L) {
            httpQuery.setConnectTimeout((int)this.connectTimeoutUnit.toMillis(this.connectTimeout));
        }
        if (this.readTimeout > 0L) {
            httpQuery.setReadTimeout((int)this.readTimeoutUnit.toMillis(this.readTimeout));
        }
        return httpQuery;
    }

    protected static Params getServiceParams(String serviceURI, Context context) throws QueryExecException {
        Map paramsMap;
        Params params = new Params();
        Map serviceParams = (Map)context.get(ARQ.serviceParams);
        if (serviceParams != null && (paramsMap = (Map)serviceParams.get(serviceURI)) != null) {
            for (String param : paramsMap.keySet()) {
                if ("query".equals(param)) {
                    throw new QueryExecException("ARQ serviceParams overrides the 'query' SPARQL protocol parameter");
                }
                List values = (List)paramsMap.get(param);
                for (String value : values) {
                    params.addParam(param, value);
                }
            }
        }
        return params;
    }

    public void cancel() {
        this.finished = true;
    }

    @Override
    public void abort() {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.finished = true;
        if (this.retainedConnection != null) {
            try {
                this.retainedConnection.close();
            }
            catch (IOException e2) {
                log.warn("Failed to close connection", (Throwable)e2);
            }
            finally {
                this.retainedConnection = null;
            }
        }
    }

    public String toString() {
        HttpQuery httpQuery = this.makeHttpQuery();
        return "GET " + httpQuery.toString();
    }

    public void setSelectContentType(String contentType) {
        boolean ok = false;
        for (String supportedType : supportedSelectContentTypes) {
            if (!supportedType.equals(contentType)) continue;
            ok = true;
            break;
        }
        if (!ok) {
            throw new IllegalArgumentException("Given Content Type '" + contentType + "' is not a supported SELECT results format");
        }
        this.selectContentType = contentType;
    }

    public void setAskContentType(String contentType) {
        boolean ok = false;
        for (String supportedType : supportedAskContentTypes) {
            if (!supportedType.equals(contentType)) continue;
            ok = true;
            break;
        }
        if (!ok) {
            throw new IllegalArgumentException("Given Content Type '" + contentType + "' is not a supported ASK results format");
        }
        this.askContentType = contentType;
    }

    public void setModelContentType(String contentType) {
        Lang lang = WebContent.contentTypeToLang(contentType);
        if (lang == null) {
            throw new IllegalArgumentException("Given Content Type '" + contentType + "' is not supported by RIOT");
        }
        if (!RDFLanguages.isTriples(lang)) {
            throw new IllegalArgumentException("Given Content Type '" + contentType + " is not a RDF Graph format");
        }
        this.modelContentType = contentType;
    }
}

