% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rl_measures.R
\name{rl_measures}
\alias{rl_measures}
\alias{rl_measures_}
\title{Get species conservation measures by taxon name, IUCN id, and region}
\usage{
rl_measures(name = NULL, id = NULL, region = NULL, key = NULL,
  parse = TRUE, ...)

rl_measures_(name = NULL, id = NULL, region = NULL, key = NULL, ...)
}
\arguments{
\item{name}{(character) Binomial taxonomic name}

\item{id}{(character) IUCN id}

\item{region}{(character) Binomial taxonomic name}

\item{key}{A IUCN API token}

\item{parse}{(logical) Whether to parse to list (\code{FALSE}) or
data.frame (\code{TRUE}). Default: \code{TRUE}}

\item{...}{Curl options passed to \code{\link[crul]{HttpClient}}}
}
\value{
A list, with the data in the \code{result} slot, unless using
a function with a trailing underscore, in which case json as character
string is returned.
}
\description{
Get species conservation measures by taxon name, IUCN id, and region
}
\examples{
\dontrun{
rl_measures('Fratercula arctica')
rl_measures('Fratercula arctica', region = 'europe')
rl_measures(id = 12392)
rl_measures(id = 22694927, region = 'europe')

rl_measures_('Fratercula arctica')
rl_measures_(id = 22694927, region = 'europe')
}
}
\references{
API docs at \url{http://apiv3.iucnredlist.org/api/v3/docs}
}

