% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random_tree.r
\name{random_tree}
\alias{random_tree}
\title{Create a random ranked phylogeny}
\usage{
random_tree(n)
}
\arguments{
\item{n}{the number of tips}
}
\value{
random ranked tree of class "rankedPhylo"
}
\description{
Create a random ranked phylogeny using the coalescent method.
}
\details{
This is implementation of a ranked coalescent algorithm described in Collienne (2021).
Starting from \code{n} tips of a tree, all with rank 0, randomly select two tips and merge them
into a new node with rank 1, and add the new node to remaining tips. In next iteration, assign
rank 2 and so on, until only a single node, the root, remains.
}
\examples{
random_tree(5)

}
\references{
\cite{ Collienne, L. (2021). Spaces of Phylogenetic Time Trees (p. 158). University of Otago. }
}
