% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moveReduce.R
\name{moveReduce}
\alias{moveReduce}
\title{moveReduce}
\usage{
moveReduce(x, y, z, derive.raster = FALSE)
}
\arguments{
\item{x}{Object of class \emph{SpatialPoints} or \emph{SpatialPointsDataFrame}.}

\item{y}{Object of class \emph{RasterLayer}, \emph{RasterStack} or \emph{RasterBrick}.}

\item{z}{Object of class \emph{Date}, \emph{POSIXlt} or \emph{POSIXct} with \emph{x} observation dates.}

\item{derive.raster}{Should a raster with the total time per pixel be provided?}
}
\value{
A \emph{list} object.
}
\description{
Pixel based summary of movement data that preserves periodic movements.
}
\details{
{Reduces a set of input samples (\emph{x}) based on their corresponding pixel coordinates
within a reference raster (\emph{y}). Using this data, the function identifies temporal segments
corresponding to groups of consecutive samples found within the same pixel. In this process, revisits
to recorded pixels are preserved. Once the segments are identified, the function derives mean x and y
coordinates for each of them and evaluates the time spent within each pixel. The function reports on
the start and end timestamps, the mean timestamp and the elapsed time. The output of the function
consists of:
\itemize{
\item{\emph{r.shp} - Shapefile with reduced sample set and its corresponding temporal information.}
\item{\emph{total.time} - Raster showing the total time spent at each pixel (if \emph{derive.raster} is TRUE).}
\item{\emph{indices} - Indices for each sample in \emph{x} showing which samples were aggregated.}}

}
}
\examples{
{

 require(raster)

 # read raster data
 r <- raster(system.file('extdata', '2013-07-16_ndvi.tif', package="rsMove"))

 # read movement data
 data(shortMove)

 # observation time
 z <- strptime(paste0(shortMove@data$date, ' ', shortMove@data$time),
 format="\%Y/\%m/\%d \%H:\%M:\%S")

 # reduce amount of samples
 move.reduce <- moveReduce(shortMove, r, z)

}
}
\seealso{
\code{\link{sampleMove}} \code{\link{moveSeg}}
}
