% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_article_footnotes.R
\name{get_article_footnotes}
\alias{get_article_footnotes}
\title{Scrape footnotes from a single article hosted on Scielo}
\usage{
get_article_footnotes(x)
}
\arguments{
\item{x}{a character vector with the link or id of the article hosted on
Scielo to be scrapped.}
}
\value{
The function returns a \code{tibble} with the following variables:

\itemize{
  \item footnote: article's footnotes (\code{character}).
  \item doi: article's Digital Object Identifier (\code{character}).
}
}
\description{
\code{get_article_footnotes()} scrapes all the footnotes iin an article hosted
on Scielo.
}
\note{
Sometimes, the Scielo website is offline for maintaince,
in which cases this function will not work (i.e., users will get HTML status
different from the usual 200 OK).
}
\examples{
\donttest{
df <- get_article_fnotes(x = "http://www.scielo.br/scielo.php?
script=sci_arttext&pid=S1981-38212016000200201&lng=en&nrm=iso&tlng=en")
}
}
