# Standalone file: do not edit by hand
# Source: https://github.com/posit-dev/snowflakeauth/blob/HEAD/R/standalone-credentials.R
# Generated by: usethis::use_standalone("posit-dev/snowflakeauth", "credentials")
# ----------------------------------------------------------------------
#
#' Get credentials for a Snowflake connection
#' @param params a list of connection parameters from `[snowflake_connection()]``
#' @param role a snowflake entity
#' @param spcs_endpoint a Snowpark Container Services ingress URL, formatted (*-accountname.snowflakecomputing.app)
#' @param ... Additional Snowflake connection parameters
#'
#' @returns A list of HTTP headers.
#' @keywords internal
snowflake_credentials <- function(
  params,
  role = NULL,
  spcs_endpoint = NULL,
  ...
) {
  role <- role %||% params$role
  switch(
    params$authenticator,
    oauth = oauth_credentials(params$token, params$token_file_path),
    SNOWFLAKE_JWT = keypair_credentials(
      params$account,
      params$user,
      params$private_key_file %||% params$private_key,
      spcs_endpoint,
      role
    ),
    cli::cli_abort(c(
      "Unsupported authenticator: {.str {params$authenticator}}.",
      "i" = "Only OAuth and key-pair authentication are supported."
    ))
  )
}

oauth_credentials <- function(token = NULL, token_file = NULL) {
  if (!is.null(token_file)) {
    tryCatch(
      token <- readLines(token_file, warn = FALSE, encoding = "UTF-8"),
      error = function(e) {
        cli::cli_abort(
          "Failed to read OAuth token from {.file {token_file}}.",
          parent = e
        )
      }
    )
  }
  list(
    Authorization = paste("Bearer", token),
    `X-Snowflake-Authorization-Token-Type` = "OAUTH"
  )
}
