% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tasks.R
\name{taskLog}
\alias{taskLog}
\title{Show task log}
\usage{
taskLog(taskId, account = NULL, server = NULL, output = NULL)
}
\arguments{
\item{taskId}{Task Id}

\item{account, server}{Uniquely identify a remote server with either your
user \code{account}, the \code{server} name, or both. If neither are supplied, and
there are multiple options, you'll be prompted to pick one.

Use \code{\link[=accounts]{accounts()}} to see the full list of available options.}

\item{output}{Where to write output. Valid values are \code{NULL} or \code{stderr}}
}
\description{
Writes the task log for the given task
}
\note{
This function works only with shinyapps.io and posit.cloud.
}
\examples{
\dontrun{

# write task log to stdout
taskLog(12345)

# write task log to stderr
taskLog(12345, output="stderr")

}
}
\seealso{
\code{\link[=tasks]{tasks()}}
}
