% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/envvars.R
\name{listAccountEnvVars}
\alias{listAccountEnvVars}
\alias{updateAccountEnvVars}
\title{Maintain environment variables across multiple applications}
\usage{
listAccountEnvVars(server = NULL, account = NULL)

updateAccountEnvVars(envVars, server = NULL, account = NULL)
}
\arguments{
\item{account, server}{Uniquely identify a remote server with either your
user \code{account}, the \code{server} name, or both. If neither are supplied, and
there are multiple options, you'll be prompted to pick one.

Use \code{\link[=accounts]{accounts()}} to see the full list of available options.}

\item{envVars}{Names of environment variables to update. Their
values will be automatically retrieved from the current process.

If you specify multiple environment variables, any application that
uses any of them will be updated with all of them.}
}
\value{
\code{listAccountEnvVars()} returns a data frame with one row
for each data frame. It has variables \code{id}, \code{guid}, \code{name}, and
\code{envVars}. \code{envVars} is a list-column.
}
\description{
\itemize{
\item \code{listAccountEnvVars()} lists the environment variables used by
every application published to the specified account.
\item \code{updateAccountEnvVars()} updates the specified environment variables with
their current values for every app that uses them.
}

Secure environment variable are currently only supported by Posit Connect
so other server types will generate an error.

Supported servers: Posit Connect servers
}
