% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{create_xts}
\alias{create_xts}
\title{Create an XTS Object from Resampled Signals}
\usage{
create_xts(signals, sample_rates, start_time)
}
\arguments{
\item{signals}{A list of numeric vectors representing the signals. 
Each signal in the list should correspond to one sample rate 
in the `sample_rates` argument.}

\item{sample_rates}{A numeric vector containing the sample rates for each 
signal in `signals`. The length of `sample_rates` must 
match the length of `signals`.}

\item{start_time}{The start time for the xts object. This can be a character 
string or an object that can be converted to POSIXct. The 
time is assumed to be in UTC.}
}
\value{
An xts object containing the resampled signals, with each column 
        representing one of the original signals, resampled to the highest 
        sample rate among them. The xts object's index starts from 
        `start_time` and increments at a rate of 1 divided by the maximum 
        sample rate.
}
\description{
This function takes multiple signals and their corresponding sample rates, 
resamples the signals to the highest sample rate among them, and creates 
an xts (eXtensible Time Series) object with the resampled signals aligned 
according to a provided start time.
}
\examples{
signals <- list(rnorm(100), rnorm(100))
sample_rates <- c(1, 2)
start_time <- "2020-01-01 00:00:00"
xts_data <- create_xts(signals, sample_rates, start_time)
plot(xts_data)

}
