rsleep: A R package for sleep data analysis
================

[![CRAN](https://www.r-pkg.org/badges/version/rsleep)](https://cran.r-project.org/package=rsleep)
[![Downloads](https://cranlogs.r-pkg.org/badges/grand-total/rsleep)](https://cran.r-project.org/package=rsleep)
[![License:MIT](https://img.shields.io/badge/License-MIT-blue.svg)](https://opensource.org/licenses/MIT)

rsleep is a multiplatform open-source R package providing a toolbox for sleep data processing,
visualization and analysis. rsleep provides tools for state of the art automatic sleep stages scoring.

## Installation

Development version can be directly installed from
[Github](https://github.com/) using the `devtools` package :

``` r
devtools::install_github("boupetch/rsleep")
```

Stable version can be downloaded and installed from
[CRAN](https://cran.r-project.org/):

``` r
install.packages("rsleep")
```

## Usage

``` r
library(rsleep)
```

## Vignettes

- [Spectral analysis of sleep electroencephalography
  signals](https://rsleep.org/articles/Spectral_analysis_sleep_electroencephalography.html)
  
## Examples

### Detecting R peaks in ECG signal

[<img src="https://rsleep.org/reference/detect_rpeaks-1.png" width="400">](https://rsleep.org/reference/detect_rpeaks.html)

### Processing a hypnogram

[<img src="https://rsleep.org/reference/hypnogram-1.png" width="600">](https://rsleep.org/reference/hypnogram.html)

### Plotting a hypnodensity

[<img src="https://rsleep.org/reference/plot_hypnodensity-1.png" width="600">](https://rsleep.org/reference/plot_hypnodensity.html)

### Computing a transition matrix

[<img src="https://rsleep.org/reference/transitions-1.png" width="400">](https://rsleep.org/reference/transitions.html)

## rsleep in publications

- Bouchequet P, Solelhac G, Leger D. [rsleep, un package R open-source
  pour l’analyse des polysomnographies.](https://www.sciencedirect.com/science/article/abs/pii/S1769449319304388) Médecine du Sommeil. 2020;17:67.

- Andrillon T, Solelhac G, Bouchequet P, et al. [Revisiting the value of
  polysomnographic data in insomnia: more than meets the eye.](https://www.sciencedirect.com/science/article/abs/pii/S1389945719316442) Sleep
  Medicine. 2020;66:184-200.

- Altınkaya Z, Öztürk L, Büyükgüdük İ, et al. [Non-invasive vagus nerve
  stimulation in a hungry state decreases heart rate
  variability.](https://www.sciencedirect.com/science/article/abs/pii/S0031938422003213)
  Physiology & Behavior. 2023;258:114016.
