% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download-nao.R
\name{download_nao}
\alias{download_nao}
\title{Download North Atlantic Oscillation data}
\usage{
download_nao(use_cache = FALSE, file = NULL)
}
\arguments{
\item{use_cache}{logical option to save and load from cache. If `TRUE`, results will be cached in memory
if `file` is `NULL` or on disk if `file` is not `NULL`.}

\item{file}{optional character with the full path of a file to save the data. If `cache` is `FALSE` but
`file` is not `NULL`, the results will be downloaded from the internet and saved on disk.}
}
\value{
\itemize{
\item Month: Month of record
\item Year: Year of record
\item NAO: North Atlantic Oscillation
}
}
\description{
surface sea-level pressure difference between the Subtropical (Azores) High and the Subpolar Low.
}
\examples{
\dontrun{
nao <- download_nao()
}

}
\references{
\url{https://www.ncdc.noaa.gov/teleconnections/nao}
}
