% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download-aao.R
\name{download_aao}
\alias{download_aao}
\title{Download Antarctic Oscillation data}
\usage{
download_aao(use_cache = FALSE, file = NULL)
}
\arguments{
\item{use_cache}{logical option to save and load from cache. If `TRUE`, results will be cached in memory
if `file` is `NULL` or on disk if `file` is not `NULL`.}

\item{file}{optional character with the full path of a file to save the data. If `cache` is `FALSE` but
`file` is not `NULL`, the results will be downloaded from the internet and saved on disk.}
}
\value{
\itemize{
\item Date: Date object that uses the first of the month as a placeholder. Date formatted as date on the first of the month because R only supports one partial of date time
\item Month: Month of record
\item Year: Year of record
\item AAO: Antarctic Oscillation
}
}
\description{
Projection of the monthly 700 hPa anomaly height field south of 20°S on the first EOF obtained
from the monthly 700 hPa height anomaly.
}
\examples{
\dontrun{
aao <- download_aao()
}

}
\references{
\url{https://www.cpc.ncep.noaa.gov/products/precip/CWlink/daily_ao_index/aao/aao.shtml}
}
