% Generated by roxygen2 (4.0.2): do not edit by hand
\name{peek_top}
\alias{peek_top}
\title{Return the data element at the top of an rstack}
\usage{
peek_top(s, ...)
}
\arguments{
\item{s}{rstack to peek at.}

\item{...}{additional arguments to be passed to or from methods (ignored).}
}
\value{
data element existing at the top of the rstack.
}
\description{
Simply returns the data element sitting at the top of the rstack,
leaving the rstack alone.
}
\details{
Runs in \code{O(1)} worst-case time.
}
\examples{
s <- rstack()
s <- insert_top(s, "a")
s <- insert_top(s, "b")
e <- peek_top(s)
print(e)
print(s)

## Assigning to the top data element with peek_top:
s <- rstack()
s <- insert_top(s, data.frame(a = 1, b = 1))
s <- insert_top(s, data.frame(a = 1, b = 1))

peek_top(s)$a <- 100
print(s)

peek_top(s) <- data.frame(a = 100, b = 100)
}
\seealso{
\code{\link{without_top}} for removing the top element.
}

