% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/log_lik.R
\name{log_lik}
\alias{log_lik}
\title{Generic function for pointwise log-likelihood}
\usage{
log_lik(object, ...)
}
\arguments{
\item{object}{The object to use.}

\item{...}{Arguments passed to methods.}
}
\value{
\code{log_lik} methods should return a \eqn{S} by \eqn{N} matrix,
  where \eqn{S} is the size of the posterior sample (the number of draws from
  the posterior distribution) and \eqn{N} is the number of data points.
}
\description{
We define a new function \code{log_lik} rather than a
\code{\link[stats]{logLik}} method because (in addition to the conceptual
difference) the documentation for \code{logLik} states that the return value
will be a single number, whereas \code{log_lik} returns a matrix. See
\code{log_lik.stanreg} in the \pkg{rstanarm} package for an example.
}
\examples{
# See help("log_lik", package = "rstanarm")

}
\seealso{
The \pkg{rstanarm} package for example methods
  (\url{https://CRAN.R-project.org/package=rstanarm}).

The guidelines for developers of R packages interfacing with Stan, a
  copy of which can be found in the package vignettes. See
  \code{browseVignettes("rstantools")} or \code{vignette(package =
  "rstantools")}.
}

