/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.subgroup.search;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.vikamine.kernel.data.DataRecord;
import org.vikamine.kernel.data.DataRecordIteration;
import org.vikamine.kernel.subgroup.KBestSGSet;
import org.vikamine.kernel.subgroup.KBestSGSetBitSetBased;
import org.vikamine.kernel.subgroup.SG;
import org.vikamine.kernel.subgroup.SGDescription;
import org.vikamine.kernel.subgroup.SGSet;
import org.vikamine.kernel.subgroup.SGStatisticsBinary;
import org.vikamine.kernel.subgroup.SGStatisticsBuilder;
import org.vikamine.kernel.subgroup.search.InvalidTargetException;
import org.vikamine.kernel.subgroup.search.SDMethod;
import org.vikamine.kernel.subgroup.selectors.SGSelector;
import org.vikamine.kernel.subgroup.target.BooleanTarget;
import org.vikamine.kernel.util.BitSetUtils;

public class BSD
extends SDMethod {
    public static final String NAME = "BitSetSD";
    private static final boolean SORT = true;
    private BooleanTarget target;
    public int nodeCounter = 0;
    private double totalPopulationSize;
    private double definedPositives;
    private double definedNegatives;
    private Map<SGSelector, BitSet> selectorsNegatives;
    private Map<SGSelector, BitSet> selectorsPositives;
    private BitSet allTruePos;
    private BitSet allTrueNeg;
    private KBestSGSetBitSetBased result;
    private SGDescription initialSGDescription;

    @Override
    public String getName() {
        return NAME;
    }

    private List<SGSelector> getAllRelevantSelectors() {
        return new ArrayList<SGSelector>(this.selectorsPositives.keySet());
    }

    @Override
    protected SGSet search(SG initialSubgroup) {
        if (initialSubgroup.getTarget().isNumeric()) {
            throw new InvalidTargetException(initialSubgroup.getTarget(), "");
        }
        this.initialize(initialSubgroup);
        this.nodeCounter = 0;
        this.mineBitSets();
        return this.result;
    }

    private void mineBitSets() {
        this.mineBitSets((BitSet)this.allTruePos.clone(), (BitSet)this.allTrueNeg.clone(), 0, new Stack<SGSelector>(), this.getAllRelevantSelectors());
    }

    private void mineBitSets(BitSet currentBitSetPos, BitSet currentBitSetNeg, int depth, List<SGSelector> currentSelectors, List<SGSelector> relevantSelectors) {
        ArrayList<SelectorEstimate> optimisticEstimates = new ArrayList<SelectorEstimate>();
        ArrayList<SGSelector> newRelevantSelectors = new ArrayList<SGSelector>();
        for (SGSelector newSelector : relevantSelectors) {
            double optEstimatedQuality;
            if (this.aborted) {
                return;
            }
            BitSet nextBitSetPos = (BitSet)currentBitSetPos.clone();
            nextBitSetPos.and(this.selectorsPositives.get(newSelector));
            int tp = nextBitSetPos.cardinality();
            if (!this.task.fulfillsMinTPSupport(tp) || this.task.isSuppressStrictlyIrrelevantSubgroups() && nextBitSetPos.equals(currentBitSetPos)) continue;
            BitSet nextBitSetNeg = (BitSet)currentBitSetNeg.clone();
            nextBitSetNeg.and(this.selectorsNegatives.get(newSelector));
            int fp = nextBitSetNeg.cardinality();
            int n = tp + fp;
            ArrayList<SGSelector> newSelectors = new ArrayList<SGSelector>();
            newSelectors.addAll(currentSelectors);
            newSelectors.add(newSelector);
            if (!this.fullfillsMinSupportBooleanTarget(tp, n)) continue;
            ++this.nodeCounter;
            SG sg = new SG(this.getPopulation(), this.target);
            SGStatisticsBuilder.createSGStatistics(sg, tp, n - tp, this.definedPositives, this.definedNegatives, this.totalPopulationSize, this.initialSGDescription.size() + newSelectors.size(), this.getOptions());
            sg.updateQuality(this.task.getQualityFunction());
            if (this.result.isInKBestQualityRange(sg.getQuality())) {
                SGDescription newSGD = this.initialSGDescription.clone();
                newSGD.addAll(newSelectors);
                sg.setSGDescription(newSGD);
                if (!this.task.isSuppressStrictlyIrrelevantSubgroups() || !this.result.isSGStrictlyIrrelevant(nextBitSetNeg, nextBitSetPos)) {
                    this.addSubgroupToSGSet(this.result, sg, nextBitSetNeg, nextBitSetPos);
                }
            }
            if (!this.result.isInKBestQualityRange(optEstimatedQuality = this.getOptimisticEstimate(n, tp, this.totalPopulationSize, this.definedPositives))) continue;
            SelectorEstimate currentSelEstimate = new SelectorEstimate(newSelector, optEstimatedQuality, newSelectors, nextBitSetPos, nextBitSetNeg);
            optimisticEstimates.add(currentSelEstimate);
            newRelevantSelectors.add(newSelector);
        }
        if (depth + 1 < this.task.getMaxSGDSize()) {
            if (this.aborted) {
                return;
            }
            Collections.sort(optimisticEstimates);
            for (SelectorEstimate estimate : optimisticEstimates) {
                if (!this.result.isInKBestQualityRange(estimate.estimate)) continue;
                newRelevantSelectors.remove(estimate.sel);
                ArrayList<SGSelector> relevantForThisSelector = new ArrayList<SGSelector>();
                for (SGSelector sel : newRelevantSelectors) {
                    if (sel.getAttribute() == estimate.sel.getAttribute()) continue;
                    relevantForThisSelector.add(sel);
                }
                if (relevantForThisSelector.isEmpty()) continue;
                this.mineBitSets(estimate.bitSetPos, estimate.bitSetNeg, depth + 1, estimate.allSelectors, relevantForThisSelector);
            }
        }
    }

    private void initializeBitSets(SG initialSubgroup) {
        ArrayList<DataRecord> positives = new ArrayList<DataRecord>();
        ArrayList<DataRecord> negatives = new ArrayList<DataRecord>();
        DataRecordIteration iteration = new DataRecordIteration(initialSubgroup.subgroupInstanceIterator());
        for (DataRecord dr : iteration) {
            if (this.target.isPositive(dr)) {
                positives.add(dr);
                continue;
            }
            negatives.add(dr);
        }
        this.selectorsPositives = new HashMap<SGSelector, BitSet>();
        this.selectorsNegatives = new HashMap<SGSelector, BitSet>();
        for (SGSelector fSel : this.getSelectorSet(initialSubgroup, this.target)) {
            if (this.aborted) {
                return;
            }
            this.createBitSets(fSel, positives, negatives);
        }
        this.createAllTrueBitSets(positives, negatives);
    }

    private void createAllTrueBitSets(List<DataRecord> iterationPos, List<DataRecord> iterationNeg) {
        this.allTruePos = new BitSet(iterationPos.size());
        int i = 0;
        while (i < iterationPos.size()) {
            this.allTruePos.set(i);
            ++i;
        }
        this.allTrueNeg = new BitSet(iterationNeg.size());
        i = 0;
        while (i < iterationNeg.size()) {
            this.allTrueNeg.set(i);
            ++i;
        }
    }

    private void createBitSets(SGSelector lws, List<DataRecord> positives, List<DataRecord> negatives) {
        BitSet negBitSet;
        int negCardinality;
        BitSet posBitSet = BitSetUtils.generateBitSet(lws, positives);
        int posCardinality = posBitSet.cardinality();
        if (this.task.fulfillsMinTPSupport(posCardinality) && (double)((negCardinality = (negBitSet = BitSetUtils.generateBitSet(lws, negatives)).cardinality()) + posCardinality) > this.task.getMinSubgroupSize()) {
            this.selectorsPositives.put(lws, posBitSet);
            this.selectorsNegatives.put(lws, negBitSet);
        }
    }

    private void initialize(SG initialSubgroup) {
        this.target = (BooleanTarget)initialSubgroup.getTarget();
        SGStatisticsBinary stats = (SGStatisticsBinary)initialSubgroup.getStatistics();
        this.definedNegatives = stats.getNegatives();
        this.definedPositives = stats.getPositives();
        this.totalPopulationSize = stats.getDefinedPopulationCount();
        this.result = new KBestSGSetBitSetBased(this.getTask().getMaxSGCount(), this.task.getMinQualityLimit());
        this.initialSGDescription = initialSubgroup.getSGDescription();
        this.initializeBitSets(initialSubgroup);
    }

    protected boolean doAddSGToSGSet(KBestSGSet sgSet, SG sg, BitSet nextBitSetAll, BitSet nextBitSetPositives) {
        return sgSet.isInKBestQualityRange(sg.getQuality()) && (!this.task.isSuppressStrictlyIrrelevantSubgroups() || !this.result.isSGStrictlyIrrelevant(nextBitSetAll, nextBitSetPositives));
    }

    protected void addSubgroupToSGSet(KBestSGSetBitSetBased result, SG sg, BitSet nextBitSetNegatives, BitSet nextBitSetPositives) {
        result.addByReplacingWorstSG(sg, nextBitSetNegatives, nextBitSetPositives);
        if (this.task.isSuppressStrictlyIrrelevantSubgroups()) {
            result.testAndRemoveIrrelevantSubgroupsFromSGSet();
        }
    }

    @Override
    public boolean isTreatMissingAsUndefinedSupported() {
        return false;
    }

    private static class SelectorEstimate
    implements Comparable<SelectorEstimate> {
        private final SGSelector sel;
        private final double estimate;
        private final List<SGSelector> allSelectors;
        private final BitSet bitSetPos;
        private final BitSet bitSetNeg;

        public SelectorEstimate(SGSelector sel, double estimate, List<SGSelector> allSelectors, BitSet bitsetPos, BitSet bitsetNeg) {
            this.sel = sel;
            this.estimate = estimate;
            this.allSelectors = allSelectors;
            this.bitSetPos = bitsetPos;
            this.bitSetNeg = bitsetNeg;
        }

        @Override
        public int compareTo(SelectorEstimate o) {
            return -Double.compare(this.estimate, o.estimate);
        }

        public String toString() {
            return this.sel + ": " + this.estimate;
        }
    }
}

