/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.persistence;

import java.text.ParseException;
import java.util.Collections;
import org.vikamine.kernel.data.Attribute;
import org.vikamine.kernel.data.AttributeProvider;
import org.vikamine.kernel.data.Ontology;
import org.vikamine.kernel.data.Value;
import org.vikamine.kernel.persistence.SelectorMarshaller;
import org.vikamine.kernel.persistence.ValuesMarshaller;
import org.vikamine.kernel.subgroup.selectors.DefaultSGSelector;
import org.vikamine.kernel.subgroup.selectors.SGNominalSelector;
import org.vikamine.kernel.subgroup.selectors.SGSelector;
import org.vikamine.kernel.util.DOMAccessor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DiscretizedSelectorMarshaller
implements SelectorMarshaller {
    @Override
    public void marshall(SGSelector selector, Element element, Document document) {
        Attribute att = selector.getAttribute();
        Element attNode = document.createElement("attribute");
        attNode.appendChild(document.createTextNode(att.getId()));
        element.appendChild(attNode);
        Value.CustomDiscretizedValue disc = (Value.CustomDiscretizedValue)((DefaultSGSelector)selector).getValues().iterator().next();
        new ValuesMarshaller().createValueNode(document, attNode, disc);
    }

    @Override
    public SGNominalSelector unmarshall(Element element, AttributeProvider attributeProvider, Ontology ontomanager) throws ParseException {
        String id = DOMAccessor.getChildNodeText(element, "attribute");
        Attribute att = attributeProvider.getAttribute(id);
        if (att == null) {
            throw new ParseException("Unknown attribute: " + id, -1);
        }
        NodeList values = element.getElementsByTagName("discretizedValue");
        if (values.getLength() == 0) {
            throw new ParseException("missing discretizedvalue", -1);
        }
        Element child = (Element)values.item(0);
        Value disc = new ValuesMarshaller().parseValueNode(attributeProvider, ontomanager, child);
        return new DefaultSGSelector(att, Collections.singleton(disc));
    }
}

