% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/os_districts.R
\name{os_districts}
\alias{os_districts}
\title{Search OpenStates districts}
\usage{
os_districts(state, chamber = NULL, abbr = NULL, boundary_id = NULL,
  id = NULL, legislators = NULL, name = NULL, num_seats = NULL,
  as = "table", key = NULL, ...)
}
\arguments{
\item{state}{state two-letter abbreviation (character). required}

\item{chamber}{Whether this district belongs to the upper or
lower chamber. (character)}

\item{abbr}{State abbreviation. (character)}

\item{boundary_id}{boundary_id used in District Boundary Lookup (character)}

\item{id}{A unique ID for this district (separate from boundary_id).}

\item{legislators}{List of legislators that serve in this district. (may be
more than one if num_seats > 1)}

\item{name}{Name of the district (e.g. '14', '33A', 'Fifth Suffolk')}

\item{num_seats}{Number of legislators that are elected to this seat.
Generally one, but will be 2 or more if the seat is a multi-member district.}

\item{as}{(character) One of table (default), list, or response
(\code{crul} response object)}

\item{key}{your SunlightLabs API key; loads from .Rprofile}

\item{...}{Curl options passed on to \link[crul:HttpClient]{crul::HttpClient}}
}
\value{
a data.frame of bills.
}
\description{
Search OpenStates districts
}
\details{
this route appears to not support pagination, sorting or
selecting fields
}
\examples{
\dontrun{
os_districts(state = 'tx')
os_districts(state = 'tx', chamber = 'upper')
os_districts(state = 'dc')
os_districts(state = 'dc', per_page=3)
os_districts(state = 'dc', per_page=3, sort='created_at')
}
}
