% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scto_get_attachments.R
\name{scto_get_attachments}
\alias{scto_get_attachments}
\title{Download file attachments from a SurveyCTO form}
\usage{
scto_get_attachments(
  auth,
  urls,
  output_dir,
  private_key = NULL,
  overwrite = TRUE
)
}
\arguments{
\item{auth}{\code{\link[=scto_auth]{scto_auth()}} object.}

\item{urls}{Character vector of API URLs for file attachments. Will typically
be derived from a column of a \code{data.table} returned by \code{\link[=scto_read]{scto_read()}}. Can
contain missing values.}

\item{output_dir}{String indicating path to directory in which to save files.}

\item{private_key}{String indicating path to private key file. Only needs to
be non-\code{NULL} to decrypt encrypted file attachments.}

\item{overwrite}{Logical indicating whether to overwrite existing files.}
}
\value{
A character vector of file names of the same length as \code{urls}, with
\code{NA} for missing or invalid URLs.
}
\description{
This function downloads files in bulk.
}
\examples{
\dontrun{
auth = scto_auth('scto_auth.txt')
scto_data = scto_read(auth, 'my_form', 'form')
filenames = scto_get_attachments(auth, scto_data[['my_attachment']])
}

}
\seealso{
\code{\link[=scto_auth]{scto_auth()}}, \code{\link[=scto_read]{scto_read()}}, \code{\link[=scto_write]{scto_write()}}
}
