# Standalone file: do not edit by hand
# Source: https://github.com/terminological/ggrrr/blob/HEAD/R/standalone-rappdirs.R
# Generated by: pkgtools::use_standalone("terminological/ggrrr", "rappdirs")
# ----------------------------------------------------------------------
#
# ---
# repo: terminological/ggrrr
# file: standalone-rappdirs.R
# last-updated: '2025-09-26'
# license: https://unlicense.org
# ---

# Standalone version of files from `https://github.com/r-lib/rappdirs` with
# minimal modification but native windows library removed.
# I'm sublicensing this as unlicense to allow for easy redistribution.

# Original licence for `https://github.com/r-lib/rappdirs`:
# MIT License
#
# Copyright (c) 2025 rappdirs authors
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.

#' Path to user cache directory
#'
#'
#' @description
#' This functions uses `R_USER_CACHE_DIR` if set. Otherwise, they follow
#' platform conventions. Typical user cache directories are:
#'
#' * Mac OS X: `~/Library/Caches/<AppName>`
#' * Linux: `~/.cache/<AppName>`
#' * Win XP: `C:\\Documents and Settings\\<username>\\Local Settings\\Application Data\\<AppAuthor>\\<AppName>\\Cache`
#' * Vista: `C:\\Users\\<username>\\AppData\\Local\\<AppAuthor>\\<AppName>\\Cache`
#'
#' @section Opinion:
#' On Windows the only suggestion in the MSDN docs is that local settings go
#' in the `CSIDL_LOCAL_APPDATA` directory. This is identical to the
#' non-roaming app data dir. But apps typically put
#' cache data somewhere *under* this directory so `rappdirs_user_cache_dir()` appends
#' `Cache` to the `CSIDL_LOCAL_APPDATA` value, unless `opinion = FALSE`.
#'
#' @param appname is the name of application. If NULL, just the system
#'     directory is returned.
#' @param appauthor (only required and used on Windows) is the name of the
#'     app author or distributing body for this application. Typically
#'     it is the owning company name. This falls back to app name.
#' @param version is an optional version path element to append to the
#'     path. You might want to use this if you want multiple versions
#'     of your app to be able to run independently. If used, this
#'     would typically be `"<major>.<minor>"`. Only applied when app name
#'     is not NULL.
#' @param os Operating system whose conventions are used to construct the
#'     requested directory. Possible values are "win", "mac", "unix". If `NULL`
#'     (the default) then the current OS will be used.
#' @param expand If TRUE (the default) will expand the `R_LIBS` specifiers with their equivalents.
#'      See [R_LIBS()] for list of all possibly specifiers.
#' @param opinion (logical) Use `FALSE` to disable the appending of
#'   `Cache` on Windows. See discussion below.
#' @seealso [tempdir()] for a non-persistent temporary directory.
#' @keywords internal
#' @unit
#' rappdirs_user_cache_dir("rappdirs")
rappdirs_user_cache_dir <- function(
  appname = NULL,
  appauthor = appname,
  version = NULL,
  opinion = TRUE,
  expand = TRUE,
  os = NULL
) {
  version <- .rappdirs_check_version(version, appname, expand)

  base <- .rappdirs_base_path(
    os,
    "CACHE",
    win = .rappdirs_win_path("local"),
    mac = "~/Library/Caches",
    unix = Sys.getenv("XDG_CACHE_HOME", "~/.cache")
  )

  switch(
    .rappdirs_check_os(os),
    win = .rappdirs_file_path(
      base,
      appauthor,
      appname,
      version,
      if (opinion) "Cache"
    ),
    mac = .rappdirs_file_path(base, appname, version),
    unix = .rappdirs_file_path(base, appname, version)
  )
}

.rappdirs_check_os <- function(os) {
  if (is.null(os)) {
    .rappdirs_get_os()
  } else {
    if (length(os) != 1 || !is.character(os)) {
      stop("`os` must be a string", call. = FALSE)
    }
    if (!os %in% c("win", "mac", "unix")) {
      stop("`os` must be one of 'win', 'mac', 'unix'", call. = FALSE)
    }
    os
  }
}

.rappdirs_get_os <- function() {
  if (.Platform$OS.type == "windows") {
    "win"
  } else if (Sys.info()["sysname"] == "Darwin") {
    "mac"
  } else {
    "unix"
  }
}

.rappdirs_file_path <- function(...) {
  paste(c(...), collapse = .Platform$file.sep)
}

.rappdirs_base_path <- function(os, type, win, mac, unix) {
  name <- paste0("R_USER_", type, "_DIR")
  val <- Sys.getenv(name)

  if (!identical(val, "")) {
    val
  } else {
    switch(.rappdirs_check_os(os), win = win, mac = mac, unix = unix)
  }
}

.rappdirs_win_path <- function(type_appdata = "common") {
  CSIDL_APPDATA <- 26L
  CSIDL_COMMON_APPDATA <- 35L
  CSIDL_LOCAL_APPDATA <- 28L

  switch(
    type_appdata,
    roaming = .rappdirs_win_path_env("roaming"),
    local = .rappdirs_win_path_env("local"),
    common = .rappdirs_win_path_env("common")
  )
}

# How to get reasonable window paths via environmental variables
.rappdirs_win_path_env <- function(type) {
  if (type == "roaming") {
    .rappdirs_env_fallback("APPDATA")
  } else if (type == "local") {
    path <- Sys.getenv("LOCALAPPDATA", unset = NA)
    if (is.na(path)) {
      # environmental variable not defined in XP
      path <- file.path(
        .rappdirs_env_fallback("USERPROFILE"),
        "Local Settings",
        "Application Data"
      )
    }
    path
  } else if (type == "common") {
    path <- Sys.getenv("PROGRAMDATA", unset = NA)
    if (is.na(path)) {
      path <- file.path(
        .rappdirs_env_fallback("ALLUSERPROFILE"),
        "Application Data"
      )
    }
    path
  } else {
    stop("invalid `type` argument")
  }
}

.rappdirs_env_fallback <- function(env) {
  val <- Sys.getenv(env)

  if (identical(val, "")) {
    if (.rappdirs_get_os() == "win") {
      stop("Can't find envvar '", env, "'", call. = FALSE)
    } else {
      # Fall back so examples still work when not on windows
      paste0("<", env, ">")
    }
  } else {
    val
  }
}

# version -----------------------------------------------------------------

.rappdirs_check_version <- function(version, appname, expand = FALSE) {
  if (is.null(appname) && !is.null(version)) {
    warning("version is ignored when appname is null", call. = FALSE)
    NULL
  } else {
    if (expand) {
      version <- .rappdirs_expand_r_libs_specifiers(version)
    }
    version
  }
}

.rappdirs_expand_r_libs_specifiers <- function(x) {
  if (is.null(x)) {
    return(NULL)
  }
  rversion <- getRversion()
  x <- .rappdirs_gsub_special("%V", rversion, x)
  x <- .rappdirs_gsub_special(
    "%v",
    paste(rversion$major, rversion$minor, sep = "."),
    x
  )
  x <- .rappdirs_gsub_special("%p", R.version$platform, x)
  x <- .rappdirs_gsub_special("%o", R.version$os, x)
  x <- .rappdirs_gsub_special("%a", R.version$arch, x)
  x <- gsub("%%", "%", x)
  x
}

.rappdirs_gsub_special <- function(pattern, replacement, x) {
  gsub(paste0("([^%]|^)", pattern), paste0("\\1", replacement), x)
}
