% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filepath.R
\name{tempfilepath}
\alias{tempfilepath}
\alias{tempfilepath,character-method}
\alias{tempfilepath,Session-method}
\alias{tempfilepath,SsimObject-method}
\title{Retrieves the temporary file path to a SyncroSim object on disk}
\usage{
tempfilepath(ssimObject)

\S4method{tempfilepath}{character}(ssimObject)

\S4method{tempfilepath}{Session}(ssimObject)

\S4method{tempfilepath}{SsimObject}(ssimObject)
}
\arguments{
\item{ssimObject}{\code{\link{Session}}, 
\code{\link{Project}}, or \code{\link{SsimLibrary}} object}
}
\value{
A character string: the temporary file path to a SyncroSim object on disk.
}
\description{
Retrieves the temporary file path to a SyncroSim \code{\link{Session}}, 
\code{\link{SsimLibrary}}, \code{\link{Project}} or \code{\link{Scenario}} 
on disk.
}
\examples{
\donttest{
# Specify file path and name of new SsimLibrary
myLibraryName <- file.path(tempdir(), "testlib")

# Set up a SyncroSim Session and SsimLibrary
mySession <- session()
myLibrary <- ssimLibrary(name = myLibraryName, session = mySession)
 
# Get the temporary file path
myFilePath <- tempfilepath(myLibrary)
}

}
