% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delete.R
\name{delete}
\alias{delete}
\alias{delete,character-method}
\alias{delete,SsimObject-method}
\title{Delete SsimLibrary, Project, Scenario, Datasheet}
\usage{
delete(
  ssimObject,
  project = NULL,
  scenario = NULL,
  datasheet = NULL,
  force = FALSE
)

\S4method{delete}{character}(
  ssimObject,
  project = NULL,
  scenario = NULL,
  datasheet = NULL,
  force = FALSE
)

\S4method{delete}{SsimObject}(
  ssimObject,
  project = NULL,
  scenario = NULL,
  datasheet = NULL,
  force = FALSE
)
}
\arguments{
\item{ssimObject}{\code{\link{SsimLibrary}}, \code{\link{Project}},
or \code{\link{Scenario}} object, or character (i.e. path to a SsimLibrary)}

\item{project}{character string, numeric, or vector of these. One or more
\code{\link{Project}} names or ids. Note that project argument is ignored
if SsimObject is a list. Note that integer ids are slightly faster (optional)}

\item{scenario}{character string, numeric, or vector of these. One or more
\code{\link{Scenario}} names or ids. Note that Scenario argument is
ignored if SsimObject is a list. Note that integer ids are slightly faster
(optional)}

\item{datasheet}{character string or vector of these. One or more Datasheet
names (optional)}

\item{force}{logical. If \code{FALSE} (default), user will be prompted to approve
removal of each item}
}
\value{
Invisibly returns a list of boolean values corresponding to each
input: \code{TRUE} upon success (i.e.successful deletion) and \code{FALSE} upon failure.
}
\description{
Deletes one or more items. Note that this is irreversible.
}
\examples{
\dontrun{
# Specify file path and name of new SsimLibrary
myLibraryName <- file.path(tempdir(), "testlib")

# Set up a SyncroSim Session, SsimLibrary, and Project
mySession <- session()
myLibrary <- ssimLibrary(name = myLibraryName, session = mySession)
myProject <- project(myLibrary, project = "a project")

# Check the Projects associated with this SsimLibrary
project(myLibrary)

# Delete Project
delete(myLibrary, project = "a project", force = TRUE)

# Check that Project was successfully deleted from SsimLibrary
project(myLibrary)
}

}
