% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rr98-data.R
\docType{data}
\name{rr98}
\alias{rr98}
\title{Ratcliff and Rouder (1998, Exp. 1) Luminance Discrimination Data}
\format{A \code{data.frame} with 24,358 obs. and 12 variables:
\describe{
 \item{id}{participant id, factor with three levels}
 \item{session}{session number, integer}
 \item{block}{block number, integer}
 \item{trial}{trial number within a block, integer}
 \item{instruction}{factor with two levels: \code{"accuracy"} for blocks with accuracy instructions; \code{"speed"} for blocks with speed instruction}
 \item{source}{factor with two levels: distribution strength was drawn from, \code{"dark"} and \code{"light"}}
 \item{strength}{proportion of white to black pixels were varied by 33 equally spaced proportions from zero (all 1,024 pixels were black) to 1 (all 1,024 pixels were white). with 0 darkest and 32 lightest. Integer.}
 \item{response}{factor with two levels: \code{"dark"} and \code{"light"}}
 \item{response_num}{numeric response variable such that \code{1="dark"} and \code{2="light"}}
 \item{correct}{boolean indicating whether or not \code{source==response}. (Does not seem to be used in the original analysis.)}
 \item{rt}{response time in seconds}
 \item{outlier}{boolean indicating whether or not the response was considered an outlier by Ratcliff and Rouder (1998), i.e., RTs outside of (200ms, 2500ms)}
}}
\source{
Ratcliff, R., & Rouder, J. N. (1998). Modeling Response Times for Two-Choice Decisions. \emph{Psychological Science}, 9(5), 347-356. http://doi.org/10.1111/1467-9280.00067
}
\usage{
rr98
}
\description{
Responses and response times from an experiment in which three participants were asked to decide whether the overall brightness of pixel arrays displayed on a computer monitor was "high" or "low". In addition, instruction manipulated speed and accuracy between blocks.
}
\details{
The Experiment is described in the following by Ratcliff and Rouder (1998, pp. 349):

In Experiment 1, subjects were asked to decide whether the overall
brightness of pixel arrays displayed on a computer monitor was "high"
or "low". The brightness of a display was controlled by the
proportion of the pixels that were white. For each trial, the proportion
of white pixels was chosen from one of two distributions, a high
distribution [i.e., light] or a low [i.e., dark] distribution, each with fixed mean and standard
deviation. Feedback was given after each trial to tell the subject whether his or her decision had correctly indicated the distribution
from which the stimulus had been chosen. Other than this feedback, a
subject had no information about the distributions. Because the distributions overlapped substantially, a subject could not be highly accurate. A display with 50% white pixels, for example, might have come
from the high distribution on one trial and the low distribution on
another.

\subsection{Stimuli}{ 
The stimulus display for Experiment 1 was a square that was 64
pixels on each side and subtended 3.8 degree of visual angle on a PC-VGA
monitor. [...] In each square, 3,072 randomly
chosen pixels were neutral gray, like the background, and the remaining 
1,024 pixels were either black or white; the proportion of white to
black pixels provided the brightness manipulation. There were 33
equally spaced proportions from zero (all 1,024 pixels were black) to
1 (all 1,024 pixels were white). The two distributions from which the
bright and dark stimuli were chosen were centered at .375 (low brightness) 
and .625 (high brightness), and they each had a standard deviation of .1875.
}

\subsection{Procedure}{
A subject's task was to decide, on each trial, from which distribution, 
high or low brightness in Experiment 1, the observed
stimulus (stimuli) had been sampled. Subjects made their decision by
pressing one of two response keys. On each trial, a 500-ms foreperiod, 
during which the display consisted solely of neutral gray, was followed 
by presentation of the stimulus; presentation was terminated by
the subject's response. In Experiment 1, speed-versus-accuracy
instructions were manipulated. For some blocks of trials, subjects
were instructed to respond as quickly as possible, and a "too slow"
message followed every response longer than 550 ms. For other
blocks of trials, subjects were instructed to be as accurate as possible,
and a "bad error" message followed incorrect responses to stimuli
from the extreme ends of the distributions. Experiment 1 had ten 35-min 
sessions, and Experiments 2 and 3 had four sessions. In Experiment 1, 
subjects switched from emphasis on speed to emphasis on
accuracy every 204 trials. Each session consisted of eight blocks of
102 trials per block, for a total of 8,160 trials per subject. Each 
session consisted of eight blocks of 102 trials, for a total of 3,264 trials
per subject in each experiment. For all trials in each experiment, subjects 
were instructed to maintain a high level of accuracy while
responding quickly, and an "error" message indicated incorrect
responses. Responses were followed by a 300-ms blank interval, and
the error message was displayed for 300 ms after the blank interval.
}
}
\note{
The data is already prepared following Ratcliff and Rouder (1998) by removing the following trials:
\itemize{
\item{the first session for each participant}
\item{the first 20 trials of each session}
\item{the first trial of each block (each change in speed accuracy starts a new block)}
}
To fully replicate the data used by Ratcliff and Rouder (1998) one only needs to remove the trials that are \code{TRUE} in column \code{outlier} (i.e., RTs outside of (200ms, 2500ms)). The full raw data is also available as part of this package, see:\cr
\code{system.file("extdata", "rr98-data", package = "rtdists")} and \code{system.file("extdata", "rr98-data.codes", package = "rtdists")}
}
\examples{

data(rr98)
rr98 <- rr98[!rr98$outlier,]  #remove outliers
head(rr98)
#   id session block trial instruction source strength response response_num correct    rt outlier
# 1 jf       2     1    21    accuracy   dark        8     dark            1    TRUE 0.801   FALSE
# 2 jf       2     1    22    accuracy   dark        7     dark            1    TRUE 0.680   FALSE
# 3 jf       2     1    23    accuracy  light       19    light            2    TRUE 0.694   FALSE
# 4 jf       2     1    24    accuracy   dark       21    light            2   FALSE 0.582   FALSE
# 5 jf       2     1    25    accuracy  light       19     dark            1   FALSE 0.925   FALSE
# 6 jf       2     1    26    accuracy   dark       10     dark            1    TRUE 0.605   FALSE

## See vignette for more examples.
}
\keyword{dataset}

