% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inertCoord.R
\name{inertCoordPlotTraj}
\alias{inertCoordPlotTraj}
\title{Plots the bivariate state variables' model-predicted temporal trajectories for each latent profile of inertia-coordination parameters.}
\usage{
inertCoordPlotTraj(
  prepData,
  paramEst,
  n_profiles,
  dist0name = NULL,
  dist1name = NULL,
  plot_obs_name = NULL,
  minMax = NULL,
  time_length = NULL,
  numPlots = NULL,
  seed = NULL,
  printPlots = T
)
}
\arguments{
\item{prepData}{A dataframe that was produced with the "dataPrep" function.}

\item{paramEst}{A dataframe created by indivInertCoord containing the inertia-coordination parameter estimates for each dyad.}

\item{n_profiles}{The number of latent profiles.}

\item{dist0name}{An optional name for the level-0 of the distinguishing variable (e.g., "Women"). Default is dist0.}

\item{dist1name}{An optional name for the level-1 of the distinguishing variable (e.g., "Men"). Default is dist1}

\item{plot_obs_name}{An optional name for the observed state variable to appear on plots (e.g., "Emotional Experience").}

\item{minMax}{An optional vector with desired minimum and maximum quantiles to be used for setting the y-axis range on the plots, e.g., minMax <- c(.1, .9) would set the y-axis limits to the 10th and 90th percentiles of the observed state variables. If not provided, the default is to use the minimum and maximum observed values of the state variables.}

\item{time_length}{An optional value specifying how many time points to plot across. Default is the 75th percentile for the time variable.}

\item{numPlots}{An optional value controlling how many random examples of each profile are produced. Default is 3.}

\item{seed}{An optional integer argument that sets the seed of R's random number generator to create reproducible trajectories. If used, the "numPlots" can be set to one - otherwise each plot is replicated 3 times.}

\item{printPlots}{If true (the default) plots are displayed on the screen.}
}
\value{
A list with the plots of predicted trajectories for each dyad.
}
\description{
Produces sets of prototypical example plots of the state variables' predicted temporal trajectories for each latent profile obtained based on the inertia-coordination parameters. The plots are produced by using the inertia-coordination parameters to predict temporal trajectories, with random noise added at each temporal step.
}
\examples{
# See vignettes for examples.

}
