% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cf_candidate_leaders.R
\name{cf_candidate_leaders}
\alias{cf_candidate_leaders}
\title{Campaign finance - candidate leaders}
\usage{
cf_candidate_leaders(campaign_cycle = NULL, category = NULL, key = NULL,
  ...)
}
\arguments{
\item{campaign_cycle}{An even-numbdered year in YYYY format. Presidential data:
2008-present; Congressional data: 2000-present}

\item{category}{Category. Specify one of these categories:
\itemize{
\item Candidate Loan \code{candidate-loan}
\item Contribution Total \code{contribution-total}
\item Debts Owed \code{debts-owed}
\item Disbursements Total \code{disbursements-total}
\item End Cash \code{end-cash}
\item Individual Total \code{individual-total}
\item PAC Total \code{pac-total}
\item Receipts Total \code{receipts-total}
\item Refund Total \code{refund-total}
}}

\item{key}{(character) your Propublica API key; pass in, or loads from .Renviron as 
\code{PROPUBLICA_API_KEY}. See \code{\link{rtimes-package}} for info on rate limits.}

\item{...}{Curl options (debugging tools mostly) passed to 
\code{\link[crul]{HttpClient}}}
}
\description{
Campaign finance - candidate leaders
}
\examples{
\dontrun{
cf_candidate_leaders(campaign_cycle = 2010, category='end-cash')
cf_candidate_leaders(campaign_cycle = 2008, category='receipts-total')
}
}
\references{
\url{http://propublica.github.io/campaign-finance-api-docs}
}
\seealso{
Other campaign-finance: \code{\link{cf_candidate_details}},
  \code{\link{cf_candidate_new}},
  \code{\link{cf_candidate_search}},
  \code{\link{cf_candidate_state}}
}
