% Generated by roxygen2 (4.0.2): do not edit by hand
\docType{class}
\name{IClusterModel}
\alias{IClusterModel}
\alias{IClusterModel-class}
\title{Interface Class [\code{\linkS4class{IClusterModel}}] for Cluster models.}
\description{
This class encapsulate the common parameters of all the Cluster models.
}
\details{
A Cluster model is a model of the form
\deqn{
  f({x}|\boldsymbol{\theta})
    \sum_{k=1}^K p_k h({x};\boldsymbol{\lambda}_k,\boldsymbol{\alpha})
   \quad {x} \in J.
}
where h can be either a pdf or a discrete probability.
}
\section{Slots}{

\describe{
\item{\code{data}}{\code{\link{matrix}} of size \eqn{n \times p} with the data set to cluster.
If the original data set had NA values, they have been estimated in the estimation process.}

\item{\code{nbCluster}}{Integer with the number of cluster of the model.}

\item{\code{pk}}{Vector of size K with the proportions of each mixture.}

\item{\code{tik}}{Matrix of size \eqn{n \times K} with the posterior probability of
the ith individual to belong to kth cluster.}

\item{\code{lnFi}}{Vector of size n with the log-likelihood of the ith individuals.}

\item{\code{zi}}{Vector of integer of size n  with the attributed class label of the individuals.}

\item{\code{missings}}{\code{\link{matrix}} of two columns with the indexes (i,j) of the missing values.}

\item{\code{lnLikelihood}}{Real given the ln-liklihood of the Cluster model.}

\item{\code{criterion}}{Real given the value of the AIC, BIC or ICL criterion.}

\item{\code{nbFreeParameter}}{Integer given the number of free parameters of the model.}

\item{\code{modelName}}{mixture model name.}

\item{\code{strategy}}{the instance of the [\code{\linkS4class{ClusterStrategy}}] used in the
estimation process of the mixture.}
}}
\examples{
getSlots("IClusterModel")
}
\author{
Serge Iovleff
}

