% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meanTech.r
\name{meanTech}
\alias{meanTech}
\title{Calculating mean of technical replicates}
\usage{
meanTech(x, groups)
}
\arguments{
\item{x}{A raw data frame including technical replicates.}

\item{groups}{grouping columns based on which the mean technical replicates are calculated.}
}
\value{
A data frame with the mean of technical replicates.
}
\description{
Calculating arithmetic mean of technical replicates for subsequent ANOVA analysis
}
\details{
The meanTech calculates mean of technical replicates. Arithmetic mean of technical replicates can be calculated in order to 
simplify the statistical comparison between sample groups.
}
\examples{

# See example input data frame:
data_withTechRep

# Calculating mean of technical replicates
meanTech(data_withTechRep, groups = 1:4)

# Calculating mean of technical replicates
meanTech(Lee_etal2020qPCR, groups = 1:3)


}
\author{
Ghader Mirzaghaderi
}
