% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fonts.R
\name{st_font}
\alias{st_font}
\title{Preview Star Trek fonts}
\usage{
st_font(family, size = 11)
}
\arguments{
\item{family}{character, font family.}

\item{size, }{numeric, font size passed to ggplot.}
}
\value{
a character vector, or a plot side effect. See details.
}
\description{
This function produces a plot showing a preview of a Star Trek font from the
\code{trekfont} package. It will return a message if any of \code{trekfont}, \code{showtext}
or \code{ggplot2} are not installed. If \code{family} is missing, it will return a
vector of all available font families.
}
\details{
In RStudio on Windows the font may not show in the RStudio graphics device.
Try using the regular R GUI.
}
\examples{
if(all(c("trekfont", "showtext", "ggplot2") \%in\% installed.packages())){
  st_font()
}
\dontrun{st_font("Federation")} # should be run in an interactive session
}
