% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text.R
\name{clean_tweets}
\alias{clean_tweets}
\title{clean_tweets}
\usage{
clean_tweets(tweets, min = 0, stopwords = NULL, exclude_words = NULL)
}
\arguments{
\item{tweets}{Character vector of tweets text. May also provide
data frame or list object with "text" named object containing
tweet text.}

\item{min}{Numeric, minimum number of ocurrences to include in
returned object. By default, \code{min = 0}, all words (except
those excluded by stopwords and exclude_words) are returned.
To only return words mentioned at least 3 times, for example,
set (\code{min = 3}).}

\item{stopwords}{Character, words to exclude. By default,
\code{stopwords = NULL}, uses a generic list of stopwords.}

\item{exclude_words}{Character, other words to exclude in
addition to generic search terms.}
}
\value{
list object top words
}
\description{
Returns list of cleaned words for each observation.
  Useful in analysis of tweet text.
}
\examples{
\dontrun{
# search for 1000 tweets mentioning Hillary Clinton
hrc <- search_tweets(q = "hillaryclinton", count = 1000)

# lookup returned user_id values
users <- lookup_users(hrc$user_id)
users

# merge data objects
dat <- dplyr::left_join(hrc, users, by = "user_id")
dat

# clean tweet text for each user
dat$words <- clean_tweets(dat, exclude_words = "hillaryclinton")
dat$words
}

}

