% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/embed-all-the-things.R
\name{starspace_save_model}
\alias{starspace_save_model}
\title{Save a starspace model as a binary or tab-delimited TSV file}
\usage{
starspace_save_model(
  object,
  file = "textspace.ruimtehol",
  method = c("ruimtehol", "tsv-data.table", "binary", "tsv-starspace"),
  labels = data.frame(code = character(), label = character(), stringsAsFactors =
    FALSE)
)
}
\arguments{
\item{object}{an object of class \code{textspace} as returned by \code{\link{starspace}} or \code{\link{starspace_load_model}}}

\item{file}{character string with the path to the file where to save the model}

\item{method}{character indicating the method of saving. Possible values are 'ruimtehol', 'binary', 'tsv-starspace' and 'tsv-data.table'. Defaults to 'ruimtehol'.
\itemize{
\item{The first method: \code{'ruimtehol'} saves the R object and the embeddings and optionally the label definitions with saveRDS. This object can be loaded back in with \code{\link{starspace_load_model}}.}
\item{The second method: \code{'tsv-data.table'} saves the model embeddings as a tab-delimited flat file using the fast data.table fwrite function}
\item{The third method: \code{'binary'} saves the model as a binary file using the original methods of the Starspace authors}
\item{The fourth method: \code{'tsv-starspace'} saves the model as a tab-delimited flat file using the original methods of the Starspace authors}
}}

\item{labels}{a data.frame with at least columns code and label which will be saved in case \code{method} is set to \code{'ruimtehol'}. 
This allows to store the mapping between Starspace labels and your own codes alongside the model, 
where code is your internal code and label is your label.\cr
A new column will be added to this data.frame called \code{label_starspace} which combines the 
Starspace prefix of the label with the code column of your provided data.frame, as this combination is the label starspace uses internally.}
}
\value{
invisibly, the character string with the file of the saved object
}
\description{
Save a starspace model as a binary or a tab-delimited TSV file
}
\note{
It is advised to always use method 'ruimtehol' method as it works nicely together with the 
\code{\link{starspace_load_model}} function. It is the advised method unless you need to provide non-R users the models 
and you prefer using the methods provided by the Starspace authors instead of the faster and more portable 'ruimtehol' method.
}
\examples{
data(dekamer, package = "ruimtehol")
dekamer$text <- strsplit(dekamer$question, "\\\\W")
dekamer$text <- lapply(dekamer$text, FUN = function(x) setdiff(x, ""))
dekamer$text <- sapply(dekamer$text, 
                       FUN = function(x) paste(x, collapse = " "))

dekamer$target <- as.factor(dekamer$question_theme_main)
codes <- data.frame(code = seq_along(levels(dekamer$target)), 
                    label = levels(dekamer$target), stringsAsFactors = FALSE)
dekamer$target <- as.integer(dekamer$target)
set.seed(123456789)
model <- embed_tagspace(x = dekamer$text, 
                        y = dekamer$target, 
                        early_stopping = 0.8,
                        dim = 10, minCount = 5)
starspace_save_model(model, file = "textspace.ruimtehol", method = "ruimtehol",
                     labels = codes)
model <- starspace_load_model("textspace.ruimtehol", method = "ruimtehol")
starspace_save_model(model, file = "embeddings.tsv", method = "tsv-data.table")

## clean up for cran
file.remove("textspace.ruimtehol")
file.remove("embeddings.tsv")
}
\seealso{
\code{\link{starspace_load_model}}
}
