% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-SparreAndersenCapitalInjections.R
\name{SparreAndersenCapitalInjections}
\alias{SparreAndersenCapitalInjections}
\title{Constructs an object of SparreAndersenCapitalInjections S4 class}
\usage{
SparreAndersenCapitalInjections(initial_capital = NULL, premium_rate = NULL,
  claim_interarrival_generator = NULL, claim_interarrival_parameters = NULL,
  claim_size_generator = NULL, claim_size_parameters = NULL,
  capital_injection_interarrival_generator = NULL,
  capital_injection_interarrival_parameters = NULL,
  capital_injection_size_generator = NULL,
  capital_injection_size_parameters = NULL)
}
\arguments{
\item{initial_capital}{a length one numeric non-negative vector specifying an
initial capital. Default: \code{0}.}

\item{premium_rate}{a length one numeric non-negative vector specifying a
premium rate. Default: \code{1}.}

\item{claim_interarrival_generator}{a function indicating the random
generator of claims' interarrival times. Default: \code{rexp}.}

\item{claim_interarrival_parameters}{a named list containing parameters for
the random generator of claims' interarrival times. Default:
\code{list(rate = 1)}.}

\item{claim_size_generator}{a function indicating the random generator of
claims' sizes. Default: \code{rexp}.}

\item{claim_size_parameters}{a named list containing parameters for the
random generator of claims' sizes. Default: \code{list(rate = 1)}.}

\item{capital_injection_interarrival_generator}{a function indicating
the random generator of capital injections' interarrival times. Default:
\code{rexp}.}

\item{capital_injection_interarrival_parameters}{a named list containing
parameters for the random generator of capital injections' interarrival
times. Default: \code{list(rate = 1)}.}

\item{capital_injection_size_generator}{a function indicating the random
generator of capital injections' sizes. Default: \code{rexp}.}

\item{capital_injection_size_parameters}{a named list containing parameters
for the random generator of capital injections' sizes. Default:
\code{list(rate = 1)}.}
}
\value{
An object of \linkS4class{SparreAndersenCapitalInjections} class.
}
\description{
\code{SparreAndersenCapitalInjections()} constructs an object of
\code{SparreAndersenCapitalInjections} S4 class.
}
\details{
The function constructs an object of a formal S4 class
\code{SparreAndersenCapitalInjections}, a representation of an extension of
Sparre Andersen model that allows for positive jumps and defined as follows:
\deqn{X_(t) = u + ct + \sum_{k=1}^{N^{(+)}(t)} Y^{(+)}_k -
\sum_{i=1}^{N^{(-)}(t)} Y^{(-)}_i}
where \eqn{u} is the initial capital (\code{initial_capital}), \eqn{c} is the
premium rate (\code{premium_rate}), \eqn{N^{(+)}(t)} is the renewal process
of positive jumps (capital injections) defined by distribution of
interarrival times (\code{capital_injection_interarrival_generator} and
\code{capital_injection_interarrival_parameters}), \eqn{Y^{(+)}_k} are iid
capital injections' sizes (\code{capital_injection_size_generator}
and \code{capital_injection_size_parameters}), \eqn{N^{(-)}(t)} is the
renewal process of claims defined by distribution of interarrival times
(\code{claim_interarrival_generator} and
\code{claim_interarrival_parameters}), \eqn{Y^{(-)}_i} are iid claim sizes
(\code{claim_size_generator} and \code{claim_size_parameters}).
}
\examples{
model <- SparreAndersenCapitalInjections(
  initial_capital = 10,
  premium_rate = 1,
  claim_interarrival_generator = rexp,
  claim_interarrival_parameters = list(rate = 1),
  claim_size_generator = rexp,
  claim_size_parameters = list(rate = 1),
  capital_injection_interarrival_generator = rexp,
  capital_injection_interarrival_parameters = list(rate = 1),
  capital_injection_size_generator = rexp,
  capital_injection_size_parameters = list(rate = 1)
)

}
\references{
Breuera L., Badescu A. L. \emph{A generalised Gerber Shiu measure for
Markov-additive risk processes with phase-type claims and capital
injections}. Scandinavian Actuarial Journal, 2014(2): 93-115, 2014.
}
\seealso{
\code{\link{CramerLundberg}},
\code{\link{CramerLundbergCapitalInjections}},
\code{link{SparreAndersen}}.
}
