% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_cubist.R, R/tidy_xrf.R
\name{tidy.cubist}
\alias{tidy.cubist}
\alias{tidy.xrf}
\title{Turn regression rule models into tidy tibbles}
\usage{
\method{tidy}{cubist}(x, ...)

\method{tidy}{xrf}(x, penalty = NULL, unit = c("rules", "columns"), ...)
}
\arguments{
\item{x}{A \code{Cubist} or \code{xrf} object.}

\item{...}{Not currently used.}

\item{penalty}{A single numeric value for the \code{lambda} penalty value.}

\item{unit}{What data should be returned? For \code{unit = 'rules'}, each row
corresponds to a rule. For \code{unit = 'columns'}, each row is a predictor
column. The latter can be helpful when determining variable importance.}
}
\value{
The Cubist method has columns \code{committee}, \code{rule_num}, \code{rule}, \code{estimate},
and \code{statistics}. The latter two are nested tibbles. \code{estimate} contains
the parameter estimates for each term in the regression model and \code{statistics}
has statistics about the data selected by the rules and the model fit.

The \code{xrf} results has columns \code{rule_id}, \code{rule}, and \code{estimate}. The
\code{rule_id} column has the rule identifier (e.g., "r0_21") or the feature
column name when the column is added directly into the model. For multiclass
models, a \code{class} column is included.

In each case, the \code{rule} column has a character string with the rule
conditions. These can be converted to an R expression using
\code{\link[rlang:parse_expr]{rlang::parse_expr()}}.
}
\description{
Turn regression rule models into tidy tibbles
}
\details{
\subsection{An example}{\if{html}{\out{<div class="r">}}\preformatted{library(dplyr)

data(ames, package = "modeldata")

ames <-
  ames \%>\%
  mutate(Sale_Price = log10(ames$Sale_Price),
         Gr_Liv_Area = log10(ames$Gr_Liv_Area))

# ------------------------------------------------------------------------------

cb_fit <-
  cubist_rules(committees = 10) \%>\%
  set_engine("Cubist") \%>\%
  fit(Sale_Price ~ Neighborhood + Longitude + Latitude + Gr_Liv_Area + Central_Air,
      data = ames)

cb_res <- tidy(cb_fit)
cb_res
}\if{html}{\out{</div>}}\preformatted{## # A tibble: 157 × 5
##    committee rule_num rule                               estimate    statistic
##        <int>    <int> <chr>                              <list>      <list>
##  1         1        1 ( Central_Air == 'N' ) & ( Gr_Liv… <tibble [4… <tibble [1…
##  2         1        2 ( Gr_Liv_Area <= 3.0326188 ) & ( … <tibble [4… <tibble [1…
##  3         1        3 ( Neighborhood  \%in\% c( 'Old_Town… <tibble [3… <tibble [1…
##  4         1        4 ( Neighborhood  \%in\% c( 'Old_Town… <tibble [4… <tibble [1…
##  5         1        5 ( Central_Air == 'N' ) & ( Gr_Liv… <tibble [4… <tibble [1…
##  6         1        6 ( Longitude <= -93.652023 ) & ( N… <tibble [4… <tibble [1…
##  7         1        7 ( Gr_Liv_Area > 3.2284005 ) & ( N… <tibble [4… <tibble [1…
##  8         1        8 ( Neighborhood  \%in\% c( 'North_Am… <tibble [4… <tibble [1…
##  9         1        9 ( Latitude <= 42.009399 ) & ( Nei… <tibble [3… <tibble [1…
## 10         1       10 ( Neighborhood  \%in\% c( 'College_… <tibble [4… <tibble [1…
## # … with 147 more rows
}\if{html}{\out{<div class="r">}}\preformatted{cb_res$estimate[[1]]
}\if{html}{\out{</div>}}\preformatted{## # A tibble: 4 × 2
##   term        estimate
##   <chr>          <dbl>
## 1 (Intercept)  -408.
## 2 Longitude      -1.43
## 3 Latitude        6.6
## 4 Gr_Liv_Area     0.7
}\if{html}{\out{<div class="r">}}\preformatted{cb_res$statistic[[1]]
}\if{html}{\out{</div>}}\preformatted{## # A tibble: 1 × 6
##   num_conditions coverage  mean   min   max  error
##            <dbl>    <dbl> <dbl> <dbl> <dbl>  <dbl>
## 1              2      154  4.94  4.11  5.31 0.0956
}\if{html}{\out{<div class="r">}}\if{html}{\out{</div>}}
}\if{html}{\out{<div class="r">}}\preformatted{xrf_rule_res <- tidy(xrf_reg_fit)
xrf_rule_res$rule[nrow(xrf_rule_res)] \%>\% rlang::parse_expr()
}\if{html}{\out{</div>}}\preformatted{## (Gr_Liv_Area < 3.30210185) & (Gr_Liv_Area < 3.38872266) & (Gr_Liv_Area >=
##     2.94571471) & (Gr_Liv_Area >= 3.24870872) & (Latitude < 42.0271072) &
##     (Neighborhood_Old_Town >= -9.53674316e-07)
}\if{html}{\out{<div class="r">}}\preformatted{xrf_col_res <- tidy(xrf_reg_fit, unit = "columns")
xrf_col_res
}\if{html}{\out{</div>}}\preformatted{## # A tibble: 149 × 3
##    rule_id term           estimate
##    <chr>   <chr>             <dbl>
##  1 r0_1    Gr_Liv_Area   -1.27e- 2
##  2 r2_4    Gr_Liv_Area   -3.70e-10
##  3 r2_2    Gr_Liv_Area    7.59e- 3
##  4 r2_4    Central_Air_Y -3.70e-10
##  5 r3_5    Longitude      1.06e- 1
##  6 r3_6    Longitude      2.65e- 2
##  7 r3_5    Latitude       1.06e- 1
##  8 r3_6    Latitude       2.65e- 2
##  9 r3_5    Longitude      1.06e- 1
## 10 r3_6    Longitude      2.65e- 2
## # … with 139 more rows
}
}

