% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NCA_Server.R
\name{mk_figure_ind_obs}
\alias{mk_figure_ind_obs}
\title{Creates Figures of Individual Observations from PKNCA Result}
\usage{
mk_figure_ind_obs(
  nca_res,
  OBS_LAB = "Concentration ===CONCUNITS===",
  TIME_LAB = "Time ===TIMEUNITS===",
  OBS_STRING = "Observation",
  BLQ_STRING = "BLQ",
  NA_STRING = "Missing",
  log_scale = TRUE,
  scales = "fixed",
  nfrows = 4,
  nfcols = 3
)
}
\arguments{
\item{nca_res}{Output of PKNCA.}

\item{OBS_LAB}{Label of the observation axis with optional ===CONCUNITS=== placeholder for units.}

\item{TIME_LAB}{Label of the time axis with optional ===TIMEUNITS=== placeholder for units.}

\item{OBS_STRING}{Label for observation data.}

\item{BLQ_STRING}{Label for BLQ data.}

\item{NA_STRING}{Label for missing data.}

\item{log_scale}{Boolean variable to control y-scale (\code{TRUE}: Log 10, \code{FALSE}: linear).}

\item{scales}{String to determine the scales used when faceting. Can be either \code{"fixed"}, \code{"free"}, \code{"free_x"}, or \code{"free_y"}.}

\item{nfrows}{Number of facet rows per page.}

\item{nfcols}{Number of facet cols per page.}
}
\value{
List containing the element \code{figures} which is a list of figure
pages (\code{"Figure 1"}, \code{"Figure 2"}, etc.). Each of these is
a also a list containing two elements:
\itemize{
\item{gg:}    A ggplot object for that page.
\item{notes:} Placeholder for future notes, but NULL now.
}
}
\description{
Takes the output of PKNCA and creates \code{ggplot} figures faceted
by subject id highlighting of certain NCA aspects (e.g. points used for half-life)
}
\examples{
id     = "NCA"
id_UD  = "UD"
id_DW  = "DW"
id_ASM = "ASM"

# We need a state variable to be define
sess_res = NCA_test_mksession(session=list(),
     id     = id,
     id_UD  = id_UD,
     id_DW  = id_DW,
     id_ASM = id_ASM,
     full_session=FALSE)

state = sess_res$state

# Pulls out the active analysis
current_ana = NCA_fetch_current_ana(state)

# This is the raw PKNCA output
pknca_res = NCA_fetch_ana_pknca(state, current_ana)

# Building the figure
mk_res = mk_figure_ind_obs(nca_res = pknca_res)
mk_res$figures$Figure_1$gg
}
