% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{window_run}
\alias{window_run}
\title{List of running windows}
\usage{
window_run(x, k = integer(1), lag = integer(1), idx = integer(0),
  na_pad = FALSE)
}
\arguments{
\item{x}{Vector of any type}

\item{k}{\code{integer} vector or single value denoting size of the running window. If \code{k} is a single
value then window size is constant for all elements, otherwise if \code{length(k) == length(x)} different
window size for each element.}

\item{lag}{\code{integer} vector or single value denoting window lag. If \code{lag} is a single
value then window lag is constant for all elements, otherwise if \code{length(lag) == length(x)} different
window size for each element.}

\item{idx}{\code{date or integer} an optional integer vector containing index of observation. If specified
then \code{k} and \code{lag} are depending on \code{idx}. Length of \code{idx} should be equal of length \code{x}}

\item{na_pad}{\code{logical} single value (default \code{na_pad=FALSE}) - if \code{TRUE} calculation on
incomplete window will return \code{NA}. Incomplete window is when some parts of the window are out of range}
}
\description{
Creates list of windows
}
\examples{
window_run(1:10, k = 3, lag = -1)
window_run(letters[1:10], k = c(1, 2, 2, 4, 5, 5, 5, 5, 5, 5))
}
