% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoencoder.R
\name{autoencode}
\alias{autoencode}
\title{Automatically compute an encoding of a data matrix}
\usage{
autoencode(data, dim, type = "basic", activation = "linear", epochs = 20)
}
\arguments{
\item{data}{Numeric matrix to be encoded}

\item{dim}{Number of variables to be used in the encoding}

\item{type}{Type of autoencoder to use: \code{"basic"}, \code{"sparse"}, \code{"contractive"},
\code{"denoising"}, \code{"robust"} or \code{"variational"}}

\item{activation}{Activation type to be used in the encoding layer. Some available
activations are \code{"tanh"}, \code{"sigmoid"}, \code{"relu"}, \code{"elu"} and \code{"selu"}}

\item{epochs}{Number of times the data will traverse the autoencoder to update its
weights}
}
\value{
Matrix containing the encodings
}
\description{
Trains an autoencoder adapted to the data and extracts its encoding for the
same data matrix.
}
\examples{
inputs <- as.matrix(iris[, 1:4])

\donttest{
if (interactive() && keras::is_keras_available()) {
  # Train a basic autoencoder and generate a 2-variable encoding
  encoded <- autoencode(inputs, 2)

  # Train a contractive autoencoder with tanh activation
  encoded <- autoencode(inputs, 2, type = "contractive", activation = "tanh")
}
}
}
\seealso{
\verb{\link{autoencoder}}
}
