% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoencoder_sparse.R
\name{autoencoder_sparse}
\alias{autoencoder_sparse}
\title{Sparse autoencoder}
\usage{
autoencoder_sparse(
  network,
  loss = "mean_squared_error",
  high_probability = 0.1,
  weight = 0.2
)
}
\arguments{
\item{network}{Layer construct of class \code{"ruta_network"}}

\item{loss}{Character string specifying a loss function}

\item{high_probability}{Expected probability of the high value of the
encoding layer. Set this to a value near zero in order to minimize
activations in that layer.}

\item{weight}{The weight of the sparsity regularization}
}
\value{
A construct of class \code{"ruta_autoencoder"}
}
\description{
Creates a representation of a sparse autoencoder.
}
\references{
\itemize{
\item \href{http://papers.nips.cc/paper/3313-sparse-deep-belief-net-model-for-visual-area-v2}{Sparse deep belief net model for visual area V2}
\item Andrew Ng, Sparse Autoencoder.
\href{https://web.stanford.edu/class/cs294a/sparseAutoencoder_2011new.pdf}{CS294A Lecture Notes}
}
}
\seealso{
\code{\link{sparsity}}, \code{\link{make_sparse}}, \code{\link{is_sparse}}

Other autoencoder variants: 
\code{\link{autoencoder_contractive}()},
\code{\link{autoencoder_denoising}()},
\code{\link{autoencoder_robust}()},
\code{\link{autoencoder_variational}()},
\code{\link{autoencoder}()}
}
\concept{autoencoder variants}
