% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apply_rv.R
\name{apply.rv}
\alias{apply.rv}
\title{Apply Functions over Margins of Random Arrays}
\usage{
apply.rv(X, MARGIN, FUN, ...)
}
\arguments{
\item{X}{a random array}

\item{MARGIN}{subscripts.}

\item{FUN}{function.}

\item{\dots}{optional arguments to \code{FUN}.}
}
\description{
The \code{rv}-compatible version of \code{apply}
}
\details{
This is the rv-compatible version of the function \code{\link{apply}}.
}
\examples{

\dontrun{
  x <- rvmatrix(rvnorm(12), nrow=3, ncol=4)
  print(apply.rv(x, 1, sum))
}

}
\references{
Kerman, J. and Gelman, A. (2007). Manipulating and Summarizing
Posterior Simulations Using Random Variable Objects. Statistics and
Computing 17:3, 235-244.

See also \code{vignette("rv")}.
}
\seealso{
\code{\link{apply}}
}
\author{
Jouni Kerman \email{jouni@kerman.com}
}
\keyword{manip}
