% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outer_rv.R
\name{outer.rv}
\alias{outer.rv}
\title{Outer Product of Random Arrays}
\usage{
outer.rv(X, Y = NULL, FUN = "*", ...)
}
\arguments{
\item{X}{First argument for function \code{FUN}}

\item{Y}{Second argument for function \code{FUN}; if missing, \code{X} is
used instead}

\item{FUN}{a function to use on the outer products; a character string or a
function}

\item{\dots}{optional arguments to be passed to \code{FUN}}
}
\value{
A random array.
}
\description{
\code{outer.rv}
}
\details{
Implements the outer product for random arrays.

Note. \code{outer} is not a generic function; thus \code{outer(x)} will not
work if \code{x} is an rv object.  You must write \code{outer.rv(x)}
explicitly.

See the function \code{outer} for further details.
}
\examples{

  #

}
\references{
Kerman, J. and Gelman, A. (2007). Manipulating and Summarizing
Posterior Simulations Using Random Variable Objects. Statistics and
Computing 17:3, 235-244.

See also \code{vignette("rv")}.
}
\author{
Jouni Kerman \email{jouni@kerman.com}
}
\keyword{classes}
