% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bicop_methods.R
\name{par_to_tau}
\alias{par_to_tau}
\alias{tau_to_par}
\title{Conversion between Kendall's tau and parameters}
\usage{
par_to_tau(family, rotation, parameters)

tau_to_par(family, tau)
}
\arguments{
\item{family}{a copula family (see \code{\link[=bicop_dist]{bicop_dist()}}) or a \link{bicop_dist} object.}

\item{rotation}{the rotation of the copula, one of \code{0}, \code{90}, \code{180}, \code{270}.}

\item{parameters}{vector or matrix of copula parameters, not used when
\code{family} is a \code{bicop_dist} object.}

\item{tau}{Kendall's \eqn{\tau}.}
}
\description{
Conversion between Kendall's tau and parameters
}
\examples{
# the following are equivalent
par_to_tau(bicop_dist("clayton", 0, 3))
par_to_tau("clayton", 0, 3)

tau_to_par("clayton", 0.5)
tau_to_par(bicop_dist("clayton", 0, 3), 0.5)
}
