% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cumulative.freq.R
\name{cumulative.freq}
\alias{cumulative.freq}
\title{Cumulative means of clade split frequencies.}
\usage{
cumulative.freq(chains, burnin = 0, window.size = 20)
}
\arguments{
\item{chains}{A list of rwty.chain objects.}

\item{burnin}{The number of trees to eliminate as burnin. Defaults to zero.}

\item{window.size}{The number of trees to include in each window (note, specified as a number of sampled trees, not a number of generations)}
}
\value{
A list of rwty.cumulative objects, one per chain in the input list of chains.
Each rwty.cumulative object contains the cumulative mean split frequencies of clades at sp
windows, and a translation table that converts clade groupings to factors.
}
\description{
This function calculates the cumulative mean split frequencies of clades as an MCMC progresses.
}
\examples{
\dontrun{
data(fungus)
cumulative.data <- cumulative.freq(fungus, burnin=20)
}
}
\keyword{MCMC,}
\keyword{convergence}
\keyword{frequency,}
\keyword{split}
