% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeplot.splitfreqs.cumulative.R
\name{makeplot.splitfreqs.cumulative}
\alias{makeplot.splitfreqs.cumulative}
\title{Plot cumulative split frequencies over the course of an MCMC}
\usage{
makeplot.splitfreqs.cumulative(chains, burnin = 0, n.clades = 20,
  window.size = 20, facet = TRUE, rank = "wcsf")
}
\arguments{
\item{chains}{A list of rwty.chain objects.}

\item{burnin}{The number of trees to eliminate as burnin}

\item{n.clades}{The number of clades to plot}

\item{window.size}{The number of trees to include in each window (note, specified as a number of sampled trees, not a number of generations)}

\item{facet}{(TRUE/FALSE). TRUE: return a single plot with one facet per chain; FALSE: return a list of individual plots with one plot per chain}

\item{rank}{('wcsf', 'sd'). How to rank the clades? By default, we plot the 20 'worst' clades. This parameter sets the definition of 'worst'. The default is to rank the by the weighted change in split frequencies (rank = 'wcsf'). This works by looking at the change in the cumulative split frequency over the course of the MCMC, and ranks the worst chains as those that do not level off (i.e. those that have changes near the end). We do this because in a well-behaved chain, we expect the cumulative split frequencies to level off once the chain has been run for long enough. So, any cumulative split frequencies which are still changing towards the end of your run are likely to indicate problematic clades. Specifically, we multiply the absolute change in split frequencies for each clade by a set of weights that increase linearly towards the end of the chain (the first observation gets a weight of zero, the final observation gets a weight of one). The original AWTY ranked clades by their standard deviations (higher SD = worse), so we include this as an option too. To do this, just set rank = 'sd'.}
}
\value{
splitfreqs.plot Either a single ggplot2 object or a list of ggplot2 objects.
}
\description{
Takes a list of rwty.chain objects.  
Plots the cumulative split frequencies of clades over the course of the MCMC. Stationarity is indicated by split frequencies levelling out.
Only plots the n.clades most variable clades, as measured by the standard deviation of the split frequencies of each clade across all windows.  
Each line in the plot represents a single clade. The colour of the line represents the standard deviation of the split frequencies of that clade across all sliding windows.
}
\examples{
\dontrun{
data(fungus)
makeplot.splitfreqs.cumulative(fungus, burnin = 20, n.clades=25)
}
}
\keyword{mcmc,}
\keyword{phylogenetics,}
\keyword{plot}
\keyword{sliding}
\keyword{window,}
