% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ano_CrossValid.R
\name{Ano_CrossValid}
\alias{Ano_CrossValid}
\title{Compute anomalies in cross-validation mode}
\usage{
Ano_CrossValid(
  exp,
  obs,
  time_dim = "sdate",
  dat_dim = c("dataset", "member"),
  memb_dim = "member",
  memb = TRUE,
  ncores = NULL
)
}
\arguments{
\item{exp}{A named numeric array of experimental data, with at least 
dimensions 'time_dim' and 'dat_dim'.}

\item{obs}{A named numeric array of observational data, same dimensions as
parameter 'exp' except along 'dat_dim'.}

\item{time_dim}{A character string indicating the name of the time dimension.
The default value is 'sdate'.}

\item{dat_dim}{A character vector indicating the name of the dataset and 
member dimensions. When calculating the climatology, if data at one 
startdate (i.e., 'time_dim') is not complete along 'dat_dim', this startdate
along 'dat_dim' will be discarded. The default value is 
"c('dataset', 'member')".}

\item{memb_dim}{A character string indicating the name of the member 
dimension. Only used when parameter 'memb' is FALSE. It must be one element
in 'dat_dim'. The default value is 'member'.}

\item{memb}{A logical value indicating whether to subtract the climatology 
based on the individual members (TRUE) or the ensemble mean over all
members (FALSE) when calculating the anomalies. The default value is TRUE.}

\item{ncores}{An integer indicating the number of cores to use for parallel 
computation. The default value is NULL.}
}
\value{
A list of 2:
\item{$exp}{
 A numeric array with the same dimensions as 'exp'. The dimension order may
 change.
}
\item{$obs}{
 A numeric array with the same dimensions as 'obs'.The dimension order may
 change.
}
}
\description{
Compute the anomalies from the arrays of the experimental and observational 
data output by subtracting the climatologies computed with a leave-one-out 
cross validation technique and a per-pair method (Garcia-Serrano and 
Doblas-Reyes, CD, 2012).
Per-pair climatology means that only the start dates covered by the 
whole experiments/observational datasets will be used. In other words, the 
startdates which do not all have values along 'dat_dim' dimension of both
the 'exp' and 'obs' are excluded when computing the climatologies.
}
\examples{
# Load sample data as in Load() example:
example(Load)
anomalies <- Ano_CrossValid(sampleData$mod, sampleData$obs)
\dontrun{
PlotAno(anomalies$exp, anomalies$obs, startDates, 
       toptitle = paste('anomalies'), ytitle = c('K', 'K', 'K'), 
       legends = 'ERSST', biglab = FALSE)
}
}
