% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CRPS.R
\name{CRPS}
\alias{CRPS}
\title{Compute the Continuous Ranked Probability Score}
\usage{
CRPS(
  exp,
  obs,
  time_dim = "sdate",
  memb_dim = "member",
  dat_dim = NULL,
  Fair = FALSE,
  return_mean = TRUE,
  ncores = NULL
)
}
\arguments{
\item{exp}{A named numerical array of the forecast with at least time 
dimension.}

\item{obs}{A named numerical array of the observation with at least time 
dimension. The dimensions must be the same as 'exp' except 'memb_dim' and 
'dat_dim'.}

\item{time_dim}{A character string indicating the name of the time dimension.
The default value is 'sdate'.}

\item{memb_dim}{A character string indicating the name of the member dimension
to compute the probabilities of the forecast. The default value is 'member'.}

\item{dat_dim}{A character string indicating the name of dataset dimension. 
The length of this dimension can be different between 'exp' and 'obs'. The
default value is NULL.}

\item{Fair}{A logical indicating whether to compute the FairCRPS (the 
potential CRPS that the forecast would have with an infinite ensemble size).
The default value is FALSE.}

\item{return_mean}{A logical indicating whether to return the temporal mean
of the CRPS or not. If TRUE, the temporal mean is calculated along time_dim,
if FALSE the time dimension is not aggregated. The default is TRUE.}

\item{ncores}{An integer indicating the number of cores to use for parallel 
computation. The default value is NULL.}
}
\value{
A numerical array of CRPS with dimensions c(nexp, nobs, the rest dimensions of
'exp' except 'time_dim' and 'memb_dim' dimensions). nexp is the number of 
experiment (i.e., dat_dim in exp), and nobs is the number of observation
(i.e., dat_dim in obs). If dat_dim is NULL, nexp and nobs are omitted.
}
\description{
The Continuous Ranked Probability Score (CRPS; Wilks, 2011) is the continuous 
version of the Ranked Probability Score (RPS; Wilks, 2011). It is a skill 
metric to evaluate the full distribution of probabilistic forecasts. It has a 
negative orientation (i.e., the higher-quality forecast the smaller CRPS) and 
it rewards the forecast that has probability concentration around the observed
value. In case of a deterministic forecast, the CRPS is reduced to the mean 
absolute error. It has the same units as the data. The function is based on 
enscrps_cpp from SpecsVerification. If there is more than one dataset, CRPS 
will be computed for each pair of exp and obs data.
}
\examples{
exp <- array(rnorm(1000), dim = c(lat = 3, lon = 2, member = 10, sdate = 50))
obs <- array(rnorm(1000), dim = c(lat = 3, lon = 2, sdate = 50))
res <- CRPS(exp = exp, obs = obs)

}
\references{
Wilks, 2011; https://doi.org/10.1016/B978-0-12-385022-5.00008-7
}
