% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file_system.R
\name{path_manipulate}
\alias{path_manipulate}
\alias{s3_path_dir}
\alias{s3_path_file}
\alias{s3_path_ext}
\alias{s3_path_ext_remove}
\alias{s3_path_ext_set}
\title{Manipulate s3 uri paths}
\usage{
s3_path_dir(path)

s3_path_file(path)

s3_path_ext(path)

s3_path_ext_remove(path)

s3_path_ext_set(path, ext)
}
\arguments{
\item{path}{(character): A character vector of paths}

\item{ext}{(character): New file extension}
}
\description{
\code{s3_path_dir} returns the directory portion of s3 uri

\code{s3_path_file} returns the file name portion of the s3 uri path

\code{s3_path_ext} returns the last extension for a path.

\code{s3_path_ext_remove} removes the last extension and return the rest of the s3 uri.

\code{s3_path_ext_set} replace the extension with a new extension.
}
\examples{
\dontrun{
# Require AWS S3 credentials

s3_path_dir("s3://my_bucket1/hi.txt")

s3_path_file("s3://my_bucket1/hi.txt")
}
}
