% This is a template R document file
% Distributed under GPL 3 or later

\name{CI.CDF}
\alias{CI.CDF}
\title{Pointwise Confidence Intervals for Kernel Smooth CDF}
\description{
  Estimate the pointwise confidence intervals for Kernel Smooth CDF.}
\usage{
 CI.CDF(CDF, alpha=0.05)
}
\arguments{
\item{CDF}{a ``CDF'' object generated by kCDF(...).}
\item{alpha}{the significant level. The default is 0.05 which generates 95\% confidence intervals for the CDF.}
}
\details{
The pointwise confidence intervals are calculated by the asymptotic distribution of the kernel estimator of CDF.   
}
\value{
A list contents 
\item{x}{the points where the CDF is estimated.}
\item{Fhat}{the estimated CDF values. These will be numerical numbers between zero and one.}
\item{Fhat.upper}{the upper boundaries of the CDF.}
\item{Fhat.lower}{the lower boundaries of the CDF.}
\item{alpha}{the significant level used.}
}
\author{
  X.F. Wang \email{wangx6@ccf.org}
}
\references{
Azzalini, A. (1981). A note on the estimation of a distribution function and quantiles by a kernel method. \emph{Biometrika}, 68, 326-328.

Wang, X.F., Fan, Z., and Wang, B. (2010). Estimating smooth distribution function in the presence of heteroscedastic measurement errors. \emph{Computational Statistics and Data Analysis}, 54(1), 25-36.
}
\seealso{
 \code{\link{kCDF}}, \code{\link{bw.CDF.pi}}.
}
\examples{

set.seed(100)
n <- 200
x <- c(rnorm(n/2, mean=-2, sd=1), rnorm(n/2, mean=3, sd=0.8))
x.CDF <- kCDF(x)
x.CDF
CI.CDF(x.CDF)
plot(x.CDF, alpha=0.05, main="Kernel estimate of distribution function")
curve(pnorm(x, mean=-2, sd=1)/2 + pnorm(x, mean=3, sd=0.8)/2, from =-6, to=6, add=TRUE, lty=2, col="blue")

}
\keyword{smoothing}

