% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bleu.R
\name{bleu_sentence_ids}
\alias{bleu_sentence_ids}
\title{Computes BLEU-Score (Papineni et al., 2002).}
\usage{
bleu_sentence_ids(
  references,
  candidate,
  n = 4,
  weights = NULL,
  smoothing = NULL,
  epsilon = 0.1,
  k = 1
)
}
\arguments{
\item{references}{A list of reference sentences.}

\item{candidate}{A candidate sentence.}

\item{n}{N-gram for BLEU score (default is set to 4).}

\item{weights}{Weights for the n-grams (default is set to 1/n for each entry).}

\item{smoothing}{Smoothing method for BLEU score (default is set to 'standard', 'floor', 'add-k' available)}

\item{epsilon}{Epsilon value for epsilon-smoothing (default is set to 0.1).}

\item{k}{K value for add-k-smoothing (default is set to 1).}
}
\value{
The BLEU score for the candidate sentence.
}
\description{
'bleu_sentence_ids' computes the BLEU score for a single candidate sentence and a list of reference sentences.
The sentences must be tokenized before so they are represented as integer vectors.
Akin to 'sacrebleu' ('Python'), the function allows the application of different smoothing methods.
Epsilon- and add-k-smoothing are available. Epsilon-smoothing is equivalent to 'floor'
smoothing in the sacrebleu implementation.
The different smoothing techniques are described in Chen et al., 2014
(https://aclanthology.org/W14-3346/).
}
\examples{
ref_corpus <- list(c(1,2,3,4))
cand_corpus <- c(1,2,3,5)
bleu_standard <- bleu_sentence_ids(ref_corpus, cand_corpus)
bleu_floor <- bleu_sentence_ids(ref_corpus, cand_corpus, smoothing="floor", epsilon=0.01)
bleu_add_k <- bleu_sentence_ids(ref_corpus, cand_corpus, smoothing="add-k", k=1)
}
