% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diff_ek.R
\name{diff_ek}
\alias{diff_ek}
\title{Differentiate x and y and compute change amplitude via an algorithm proposed by Engbert & Kliegl (2003)}
\usage{
diff_ek(x, y, trial, sample_rate, options = NULL)
}
\arguments{
\item{x}{vector with x coordinates in \emph{degrees of visual angle}}

\item{y}{vector with y coordinates in \emph{degrees of visual angle}}

\item{trial}{vector with trial index}

\item{sample_rate}{sample rate in Hz}

\item{options}{List with method specific options, see Details.}
}
\value{
\code{data.frame} with columns \code{x}, \code{y}, and \code{amp}
}
\description{
Differentiate x and y and compute change amplitude via an algorithm proposed by Engbert & Kliegl (2003)
}
\details{
Method options, please refer to Engbert & Kliegl (2003) for details on parameters and the rationale for default values.
\itemize{
\item{\code{ek_velocity_time_window}} {Time window for velocity computation in milliseconds. Defaults to \code{20} ms.}
}
}
\examples{
diff_ek(rnorm(1000), rnorm(1000), rep(1, 1000), 250, list("ek_velocity_time_window" = 20))
}
\seealso{
compute_velocity_ek
}
