% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/proddnf.r
\name{proddnf}
\alias{dproddnf}
\alias{pproddnf}
\alias{proddnf}
\alias{qproddnf}
\alias{rproddnf}
\title{The product of multiple doubly non-central F's distribution.}
\usage{
dproddnf(x, df1, df2, ncp1, ncp2, log = FALSE, order.max=4)

pproddnf(q, df1, df2, ncp1, ncp2, lower.tail = TRUE, log.p = FALSE, order.max=4)

qproddnf(p, df1, df2, ncp1, ncp2, lower.tail = TRUE, log.p = FALSE, order.max=4)

rproddnf(n, df1, df2, ncp1, ncp2)
}
\arguments{
\item{x,q}{vector of quantiles.}

\item{df1,df2}{the vectors of the degrees of freedom for the numerator and denominator.
We do \emph{not} recycle these versus the \code{x,q,p,n}.}

\item{ncp1,ncp2}{the vectors of the non-centrality parameters for the numerator and denominator.
We do \emph{not} recycle these versus the \code{x,q,p,n}.}

\item{log}{logical; if TRUE, densities \eqn{f} are given
as \eqn{\mbox{log}(f)}{log(f)}.}

\item{order.max}{the order to use in the approximate density,
distribution, and quantile computations, via the Gram-Charlier,
Edeworth, or Cornish-Fisher expansion.}

\item{p}{vector of probabilities.}

\item{n}{number of observations.}

\item{log.p}{logical; if TRUE, probabilities p are given
as \eqn{\mbox{log}(p)}{log(p)}.}

\item{lower.tail}{logical; if TRUE (default), probabilities are
 \eqn{P[X \le x]}{P[X <= x]}, otherwise, \eqn{P[X > x]}{P[X > x]}.}
}
\value{
\code{dproddnf} gives the density, \code{pproddnf} gives the
distribution function, \code{qproddnf} gives the quantile function,
and \code{rproddnf} generates random deviates.

Invalid arguments will result in return value \code{NaN} with a warning.
}
\description{
Density, distribution function, quantile function and random
generation for the product of multiple independent
doubly non-central F variates.
}
\details{
Let
\deqn{x_j \sim F\left(\delta_{1,j},\delta_{2,j},\nu_{1,j},\nu_{2,j}\right)}{x_j ~ F(delta_1j,delta_2j,v_1j,v_2j)}
be independent doubly non-central F variates with non-centrality parameters
\eqn{\delta_{i,j}}{delta_ij} and degrees of freedom
\eqn{\nu_{i,j}}{v_ij} for \eqn{i=1,2,\ldots,I}{i=1,2,...,I} and
\eqn{j=1,2}{j=1,2}.
Then
\deqn{Y = \prod_j x_j}{Y = prod x_j}
takes a product of doubly non-central F's distribution. We take the
parameters of this distribution as the four \eqn{I}{I} length vectors
of the two degrees of freedom and the two non-centrality parameters.
}
\note{
The PDF, CDF, and quantile function are approximated, via
the Edgeworth or Cornish Fisher approximations, which may
not be terribly accurate in the tails of the distribution.
You are warned.

The distribution parameters are \emph{not} recycled
with respect to the \code{x, p, q} or \code{n} parameters,
for, respectively, the density, distribution, quantile
and generation functions. This is for simplicity of
implementation and performance. It is, however, in contrast
to the usual R idiom for dpqr functions.

The PDQ functions are computed by translation of the
sum of log chi-squares distribution functions.
}
\examples{
df1 <- c(10,20,5)
df2 <- c(1000,500,150)
ncp1 <- c(1,0,2.5)
ncp2 <- c(0,1.5,5)

rv <- rproddnf(500, df1=df1,df2=df2,ncp1=ncp1,ncp2=ncp2)
d1 <- dproddnf(rv, df1=df1,df2=df2,ncp1=ncp1,ncp2=ncp2)
\dontrun{
plot(rv,d1)
}
p1 <- pproddnf(rv, df1=df1,df2=df2,ncp1=ncp1,ncp2=ncp2)
# should be nearly uniform:
\dontrun{
plot(ecdf(p1))
}
q1 <- qproddnf(ppoints(length(rv)), df1=df1,df2=df2,ncp1=ncp1,ncp2=ncp2)
\dontrun{
qqplot(x=rv,y=q1)
}
}
\author{
Steven E. Pav \email{shabbychef@gmail.com}
}
\references{
Pav, Steven. Moments of the log non-central chi-square distribution.
\url{http://arxiv.org/abs/1503.06266}
}
\seealso{
The sum of log of chi-squares distribution,
\code{\link{dsumlogchisq}},
\code{\link{psumlogchisq}},
\code{\link{qsumlogchisq}},
\code{\link{rsumlogchisq}}.
(doubly non-central) F distribution functions,
\code{\link{ddnf}},
\code{\link{pdnf}},
\code{\link{qdnf}},
\code{\link{rdnf}}.
}
\keyword{distribution}

