% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HurdleNB.R
\name{HurdleNB}
\alias{HurdleNB}
\title{Small Area Estimation using Hierarchical Bayesian under Hurdle Negative Binomial Distribution}
\usage{
HurdleNB(
  formula,
  iter.update = 3,
  iter.mcmc = 2000,
  coef.nonzero,
  var.coef.nonzero,
  coef.zero,
  var.coef.zero,
  thin = 1,
  burn.in = 1000,
  tau.u = 1,
  tau.v = 1,
  data
)
}
\arguments{
\item{formula}{Formula that describe the fitted model}

\item{iter.update}{Number of updates with default \code{3}}

\item{iter.mcmc}{Number of total iterations per chain with default \code{2000}}

\item{coef.nonzero}{Optional vector for the mean of the prior distribution of the model coefficients \eqn{(\beta)} for variable of interest \eqn{(y)} which value is zero count}

\item{var.coef.nonzero}{Optional vector of variance of coefficient non-zero count}

\item{coef.zero}{Optional vector for the mean of the prior distribution of the model coefficients \eqn{(\gamma)} for variable of interest \eqn{(y)} which value is zero count}

\item{var.coef.zero}{Optional vector for variance of coefficient zero count}

\item{thin}{Thinning rate, must be a positive integer with default \code{1}}

\item{burn.in}{Number of iterations to discard at the beginning with default \code{1000}}

\item{tau.u}{Variance of random effect area for non-zero count of variable interest with default \code{1}}

\item{tau.v}{Variance of random effect area for zero count of variable interest with default \code{1}}

\item{data}{The data frame}
}
\value{
This function returns a list of the following objects:
   \item{Est}{A vector with the values of Small Area mean Estimates using Hierarchical bayesian method }
   \item{refVar}{Estimated random effect variances}
   \item{coefficient}{A dataframe with the estimated model coefficient}
   \item{plot}{Trace, Density, Autocorrelation Function Plot of MCMC samples}
}
\description{
This function is implemented to variable of interest \eqn{(y)} that assumed to be a Hurdle Negative Binomial Distribution. The value of variable of interest must be a non-negative data count. This model can be used to handle overdispersion and excess zero in data.
}
\examples{
##For data without any non-sampled area
data(dataHNB)     # Load dataset

\donttest{result <- HurdleNB(y ~ x1 + x2, data = dataHNB)}

\donttest{result$Est}          # Small Area mean Estimates
\donttest{result$refVar}       # Estimated random effect variances
\donttest{result$coefficient}  # Estimated model coefficient

# Load library 'coda' to execute the plot
# autocorr.plot(result$plot[[3]])    # Generate ACF Plot
# plot(result$plot[[3]])             # Generate Density and Trace plot

## For data with non-sampled area use dataHNBNS

}
