#' @title Synthetics Data for Small Area Estimation using Hierarchical Bayesian Method under Zero Inflated Negative Binomial
#'
#' @description Datasets to simulate Small Area Estimation using Hierarchical Bayesian Method under Zero Inflated Negative Binomial.
#'
#' This data is generated by these following steps:
#'
#' \enumerate{
#' \item Generate sampling random area effect \code{u} and \code{v} with  \code{u ~ N(0,1)} and \code{v ~ N(0,1)}.
#' \item The auxiliary variables are generated by uniform and bernoulli distribution with  \code{x1 ~ U(0,1)} and  \code{x2 ~ B(1,0.6)}.
#' \item The coefficient parameters \eqn{ \beta_{0}, \beta_{1}, \beta_{2}, \gamma_{0}, \gamma_{1}, and \gamma_{2}}{\beta0, \beta1, \beta2, \gamma0, \gamma1, \gamma2} are set with a certain values. For the reference, see Desjardins, C.D. (2013).
#' \item Calculate \eqn{\pi}{\pi} = \eqn{exp(\gamma_{0} + x_{1}\gamma_{1} + x_{2}\gamma_{2} + u)}{exp(\gamma0 + x1\gamma1 + x2\gamma2 + u)} / \eqn{1 + exp(\gamma_{0} + x_{1}\gamma_{1} + x_{2}\gamma_{2} + u)}{1 + exp(\gamma0 + x1\gamma1 + x2\gamma2 + u)}
#' \item Calculate \eqn{\mu}{\mu} = \eqn{exp(\beta_{0} + x_{1}\beta_{1} + x_{2}\beta_{2} + v)}{exp(\beta0 + x1\beta1 + x2\beta2 + v)}
#' \item Generate direct estimate with  \code{y ~ rzinegbin} (\eqn{\mu}, \eqn{\pi}, r), we set r = 2. Using \code{library(VGAM)}
#' \item Calculate the variance of \code{y} with \code{var(y)} = \eqn{\mu} * (1 - \eqn{\pi}) * (1 + (\eqn{\mu} / r) + (\eqn{\mu} * \eqn{\pi}))
#' \item Auxiliary variables \code{x1,x2}, direct estimation \code{y} and \code{vardir} are combined in a dataframe called \code{dataZINB}
#' }
#'
#' @usage data(dataZINB)
#'
#' @format A data frame with 50 rows and 4 variables::
#' \describe{
#'   \item{y}{Direct Estimation of y}
#'   \item{x1}{Auxiliary variable of x1}
#'   \item{x2}{Auxiliary variable of x2}
#'   \item{vardir}{Sampling Variance of y}
#' }
#'
"dataZINB"
