% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logRankTest.R
\name{computeLogrankBetaFrom}
\alias{computeLogrankBetaFrom}
\title{Helper function: Computes the type II error under optional stopping based on the minimal clinically relevant hazard
ratio and the maximum number of nEvents.}
\usage{
computeLogrankBetaFrom(
  hrMin,
  nEvents,
  m0 = 50000L,
  m1 = 50000L,
  alpha = 0.05,
  alternative = c("two.sided", "greater", "less"),
  nSim = 1000L,
  nBoot = 10000L,
  groupSizePerTimeFunction = returnOne,
  parameter = NULL,
  pb = TRUE
)
}
\arguments{
\item{hrMin}{numeric that defines the minimal relevant hazard ratio, the smallest hazard ratio that we want to
detect.}

\item{nEvents}{numeric > 0, targetted number of events.}

\item{m0}{Number of subjects in the control group 0/1 at the beginning of the trial, i.e., nPlan[1].}

\item{m1}{Number of subjects in the treatment group 1/2 at the beginning of the trial, i.e., nPlan[2].}

\item{alpha}{numeric in (0, 1) that specifies the tolerable type I error control --independent on n-- that the
designed test has to adhere to. Note that it also defines the rejection rule e10 > 1/alpha.}

\item{alternative}{a character string specifying the alternative hypothesis, which must be one of
"two.sided" (default),"greater" or "less". The alternative is pitted against the null hypothesis of equality
of the survival distributions. More specifically, let lambda1 be the hazard rate of group 1 (i.e., placebo), and
lambda2 the hazard ratio of group 2 (i.e., treatment), then the null hypothesis states that the hazard ratio
theta = lambda2/lambda1 = 1. If alternative = "less", the null hypothesis is compared to theta < 1, thus,
lambda2 < lambda1, that is, the hazard of group 2 (i.e., treatment) is less than that of group 1 (i.e., placebo),
hence, the treatment is beneficial. If alternative = "greater", then the null hypothesis is compared to theta > 1,
thus, lambda2 > lambda1, hence, harm.}

\item{nSim}{integer > 0, the number of simulations needed to compute power or the number of events for the exact
safe logrank test under continuous monitoring}

\item{nBoot}{integer > 0 representing the number of bootstrap samples to assess the accuracy of the approximation of
power or nEvents for the exact safe logrank test under continuous monitoring}

\item{groupSizePerTimeFunction}{A function without parameters and integer output. This function provides the number
of events at each time step. For instance, if \code{rpois(1, 7)} leads to a random number of events at each time
step.}

\item{parameter}{Numeric > 0, represents the safe tests defining thetaS. Default NULL so it's decided by the
algorithm, typically, this equals hrMin, which corresponds to the GROW choice.}

\item{pb}{logical, if \code{TRUE}, then show progress bar.}
}
\value{
a list which contains at least beta and an adapted bootObject of class  \code{\link[boot]{boot}}.
}
\description{
Helper function: Computes the type II error under optional stopping based on the minimal clinically relevant hazard
ratio and the maximum number of nEvents.
}
\examples{
computeLogrankBetaFrom(hrMin=0.7, 300, nSim=10)
}
\author{
Muriel Felipe Perez-Ortiz and Alexander Ly
}
